/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.keywordprofile.KeywordProfile;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class KeywordProfileDB
extends DBHandler
implements CollectionObservable {
    static final String TABLE = String.valueOf(PREFIX) + "_KEYWORD_PROFILE";
    static final String SQL_INSERT_KEYWORDPROFILE = " INSERT INTO " + TABLE + " (COLLECTION_ID, KEYWORD, PROFILE_NAME, REG_DATE, APPLY) " + "VALUES ( ?, ?, ?, ?, ? ) ";
    static final String SQL_UPDATE_KEYWORDPROFILE = " UPDATE " + TABLE + " SET PROFILE_NAME = ?, REG_DATE = ?, APPLY = ?" + " WHERE COLLECTION_ID = ? AND KEYWORD = ? ";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ?";
    static final String SQL_SELECT_KEYWORDPROFILE = " SELECT COLLECTION_ID, KEYWORD, PROFILE_NAME, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND KEYWORD = ? ";
    static final String SQL_SELECT_PROFILE_KEYWORDPROFILE = " SELECT COLLECTION_ID, KEYWORD, PROFILE_NAME, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_SELECT_COUNT_KEYWORDPROFILE = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_SELECT_COUNT_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_DELETE_KEYWORDPROFILE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND KEYWORD = ? ";
    static final String SQL_DELETE_PROFILE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";

    public static void put(Connection conn, KeywordProfile keywordProfile) throws SQLException {
        String collectionID = keywordProfile.getCollectionID();
        String keyword = keywordProfile.getKeyword();
        String profileName = keywordProfile.getProfileName();
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        KeywordProfileDB.put(conn, collectionID, keyword, profileName, regDate, apply);
    }

    public static void put(Connection conn, String collectionID, String keyword, String profileName) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        if (StringUtil.isEmpty((String)profileName)) {
            throw new SQLException("profileName is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        KeywordProfileDB.put(conn, collectionID, keyword, profileName, regDate, apply);
    }

    private static void put(Connection conn, String collectionID, String keyword, String profileName, Timestamp regDate, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        if (StringUtil.isEmpty((String)profileName)) {
            throw new SQLException("profileName is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("KEYWORD", 2, keyword), new RdbmsStringColumnParameter("PROFILE_NAME", 3, profileName), new RdbmsDateColumnParameter("REG_DATE", 4, regDate), new RdbmsIntColumnParameter("APPLY", 5, apply ? 1 : 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_KEYWORDPROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void update(Connection conn, KeywordProfile keywordProfile) throws SQLException {
        String collectionID = keywordProfile.getCollectionID();
        String keyword = keywordProfile.getKeyword();
        String profileName = keywordProfile.getProfileName();
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        KeywordProfileDB.update(conn, collectionID, keyword, profileName, regDate, apply);
    }

    public static void update(Connection conn, String collectionID, String keyword, String profileName) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        if (StringUtil.isEmpty((String)profileName)) {
            throw new SQLException("profileName is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        profileName = KeywordProfileDB.toUpperTrim(profileName);
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        KeywordProfileDB.update(conn, collectionID, keyword, profileName, regDate, apply);
    }

    private static void update(Connection conn, String collectionID, String keyword, String profileName, Timestamp regDate, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        if (StringUtil.isEmpty((String)profileName)) {
            throw new SQLException("profileName is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("PROFILE_NAME", 1, profileName), new RdbmsDateColumnParameter("REG_DATE", 2, regDate), new RdbmsIntColumnParameter("APPLY", 3, apply ? 1 : 0), new RdbmsStringColumnParameter("COLLECTION_ID", 4, collectionID), new RdbmsStringColumnParameter("KEYWORD", 5, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_KEYWORDPROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateApply(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static KeywordProfile get(Connection conn, String collectionID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("KEYWORD", 2, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_KEYWORDPROFILE, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return KeywordProfile.create(native_row);
    }

    public static KeywordProfile[] getListCollection(Connection conn, String collectionID, String order) throws SQLException {
        return KeywordProfileDB.getList(conn, collectionID, order);
    }

    public static KeywordProfile[] getList(Connection conn, String collectionID, String order) throws SQLException {
        order = KeywordProfileDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_PROFILE_KEYWORDPROFILE) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return KeywordProfile.create(list);
    }

    public static void copy(Connection conn, String fromCollectionID, String toCollectionID) throws SQLException {
        KeywordProfile[] list = KeywordProfileDB.getList(conn, fromCollectionID, null);
        int i = 0;
        while (i < list.length) {
            KeywordProfileDB.put(conn, toCollectionID, list[i].getKeyword(), list[i].getProfileName());
            ++i;
        }
    }

    public static int getCount(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_KEYWORDPROFILE, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountDefaultProfile(Connection conn, String collectionID) throws SQLException {
        return KeywordProfileDB.getCount(conn, collectionID);
    }

    public static KeywordProfile[] getListPage(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "KEYWORD", "PROFILE_NAME", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return KeywordProfile.create(list);
    }

    public static KeywordProfile[] getListPageDefaultProfile(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return KeywordProfileDB.getListPage(conn, collectionID, start, scale, order);
    }

    public static KeywordProfile[] getListPageDefaultProfileOrderKeyword(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return KeywordProfileDB.getListPage(conn, collectionID, start, scale, "KEYWORD ASC");
    }

    public static KeywordProfile[] getListPageDefaultProfileOrderDate(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return KeywordProfileDB.getListPage(conn, collectionID, start, scale, "REG_DATE DESC");
    }

    public static KeywordProfile[] getListPageDefaultProfileOrderApply(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return KeywordProfileDB.getListPage(conn, collectionID, start, scale, "APPLY ASC");
    }

    public static int getCountSearch(Connection conn, String collectionID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("KEYWORD", 2, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static KeywordProfile[] getListSearchPage(Connection conn, String collectionID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "KEYWORD", "PROFILE_NAME", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("KEYWORD LIKE", 2, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return KeywordProfile.create(list);
    }

    public static void delete(Connection conn, String collectionID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = KeywordProfileDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("KEYWORD", 2, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_KEYWORDPROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                KeywordProfileDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

