/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.ir.common.database.entity.profile.rankingmodel.ModelingField;
import com.diquest.ir.common.database.entity.profile.rankingmodel.RankingModel;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class RankingModelDB
extends DBHandler
implements CollectionObservable {
    public static final RankingModelDB instance = new RankingModelDB();
    static final String TABLE = String.valueOf(PREFIX) + "_RANKING_MODEL";
    static final String SQL_INSERT_RANKING_MODEL = " INSERT INTO " + TABLE + " (COLLECTION_ID, PROFILE_ID, FIELD_ID, FIELD_TYPE, WEIGHT, ENABLE) VALUES ( ?, ?, ?, ?, ?, ? ) ";
    static final String SQL_UPDATE_RANKING_MODEL = " UPDATE " + TABLE + " SET FIELD_TYPE=?, WEIGHT=?, ENABLE=? WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND FIELD_ID = ?";
    static final String SQL_SELECT_RANKING_MODEL_PROFILE = " SELECT COLLECTION_ID, PROFILE_ID, FIELD_ID, FIELD_TYPE, WEIGHT, ENABLE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ORDER BY FIELD_TYPE ASC";
    static final String SQL_SELECT = " SELECT COLLECTION_ID, PROFILE_ID, FIELD_ID, FIELD_TYPE, WEIGHT, ENABLE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND FIELD_ID = ? ";
    static final String SQL_DELETE_ALL_RANKING_MODEL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_RANKING_MODEL_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_RANKING_MODEL_PROFILE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";

    public static void put(Connection conn, RankingModel model) throws SQLException {
        String collectionID = model.getCollectionID();
        String profileID = model.getProfileID();
        ModelingField[] fields = model.getFields();
        int i = 0;
        while (i < fields.length) {
            RankingModelDB.put(conn, collectionID, profileID, fields[i]);
            ++i;
        }
    }

    private static void put(Connection conn, String collectionID, String profileID, ModelingField field) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("FIELD_ID", 3, field.getFieldID()), new RdbmsIntColumnParameter("FIELD_TYPE", 4, (int)field.getFieldType()), new RdbmsIntColumnParameter("WEIGHT", 5, field.getWeight()), new RdbmsIntColumnParameter("ENABLE", 6, field.isUse() ? 1 : 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_RANKING_MODEL, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void update(Connection conn, RankingModel model) throws SQLException {
        String collectionID = model.getCollectionID();
        String profileID = model.getProfileID();
        RankingModelDB.deleteRankingModelProfile(conn, collectionID, profileID);
        RankingModelDB.put(conn, model);
    }

    private static void update(Connection conn, String collectionID, String profileID, ModelingField field) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("FIELD_TYPE", 1, (int)field.getFieldType()), new RdbmsIntColumnParameter("WEIGHT", 2, field.getWeight()), new RdbmsIntColumnParameter("ENABLE", 3, field.isUse() ? 1 : 0), new RdbmsStringColumnParameter("COLLECTION_ID", 4, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 5, profileID), new RdbmsStringColumnParameter("FIELD_ID", 6, field.getFieldID())};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_RANKING_MODEL, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAll(Connection conn) throws Exception {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL_RANKING_MODEL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteRankingModelCollection(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_RANKING_MODEL_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteRankingModelProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_RANKING_MODEL_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static RankingModel get(Connection conn, String collectionID, String profileID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_RANKING_MODEL_PROFILE, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        if (native_rows.size() == 0) {
            return null;
        }
        return RankingModel.create(collectionID, profileID, native_rows);
    }

    private static boolean get(Connection conn, String collectionID, String profileID, String fieldID) throws SQLException {
        RdbmsColumnParameter[] parameters;
        RdbmsGeneralQuery query;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] rdbms_column_value = supporter.fetchItem(conn, query = new RdbmsGeneralQuery(SQL_SELECT, parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("FIELD_ID", 3, fieldID)}));
        return rdbms_column_value != null && rdbms_column_value.length != 0 && rdbms_column_value[0] != null;
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        RankingModel model = RankingModelDB.get(conn, fromCollectionID, fromProfileID);
        if (model != null) {
            model.setCollectionID(toCollectionID);
            model.setProfileID(toProfileID);
            RankingModelDB.put(conn, model);
        }
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                RankingModelDB.deleteRankingModelCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

