/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.recommend.Recommend;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.common.StringTokenizer;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class RecommendDB
extends DBHandler
implements CollectionObservable {
    private static final char DELIMITER = ',';
    static final String TABLE = String.valueOf(PREFIX) + "_RECOMMEND";
    static final String SQL_INSERT_RECOMMEND = " INSERT INTO " + TABLE + " (COLLECTION_ID, PROFILE_ID, KEYWORD, RECOMMEND_COUNT, RECOMMEND_LIST, REG_DATE, APPLY) " + "VALUES ( ?, ?, ?, ?, ?, ?, ? ) ";
    static final String SQL_UPDATE_RECOMMEND = " UPDATE " + TABLE + " SET RECOMMEND_COUNT=?, RECOMMEND_LIST=?, REG_DATE=?, APPLY=?" + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_RECOMMEND = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, RECOMMEND_COUNT, RECOMMEND_LIST, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_SELECT_PROFILE_RECOMMEND = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, RECOMMEND_COUNT, RECOMMEND_LIST, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_RECOMMEND = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_DELETE_RECOMMEND = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_DELETE_PROFILE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";

    public static String makeRecommendList(String[] keyword) {
        StringBuffer buf = new StringBuffer();
        buf.append(keyword[0]);
        int i = 1;
        while (i < keyword.length) {
            buf.append(',').append(keyword[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String[] makeRecommendList(String keyword) {
        char[][] tokens = StringTokenizer.token((String)keyword.trim(), (char)',');
        String[] tokenStrs = new String[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            tokenStrs[i] = new String(tokens[i]);
            ++i;
        }
        return tokenStrs;
    }

    public static void put(Connection conn, Recommend recommend) throws SQLException {
        String collectionID = recommend.getCollectionID();
        String profileID = recommend.getProfileID();
        String keyword = recommend.getKeyword();
        int recommendCount = recommend.getRecommendCount();
        String[] recommendList = recommend.getRecommendList();
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        RecommendDB.put(conn, collectionID, profileID, keyword, recommendCount, recommendList, regDate, apply);
    }

    public static void put(Connection conn, String collectionID, String profileID, String keyword, int recommendCount, String[] recommendList) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        RecommendDB.put(conn, collectionID, profileID, keyword, recommendCount, recommendList, regDate, apply);
    }

    private static void put(Connection conn, String collectionID, String profileID, String keyword, int recommendCount, String[] recommendList, Timestamp regDate, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        if (recommendCount != recommendList.length) {
            throw new IllegalArgumentException("RecommendCount(" + recommendCount + ") does not match to recommendList.length(" + recommendList.length + ")");
        }
        String recommendListString = RecommendDB.makeRecommendList(recommendList);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsIntColumnParameter("RECOMMEND_COUNT", 4, recommendCount), new RdbmsStringColumnParameter("RECOMMEND_LIST", 5, recommendListString), new RdbmsDateColumnParameter("REG_DATE", 6, regDate), new RdbmsIntColumnParameter("APPLY", 7, apply ? 1 : 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_RECOMMEND, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void update(Connection conn, Recommend recommend) throws SQLException {
        String collectionID = recommend.getCollectionID();
        String profileID = recommend.getProfileID();
        String keyword = recommend.getKeyword();
        int recommendCount = recommend.getRecommendCount();
        String[] recommendList = recommend.getRecommendList();
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        RecommendDB.update(conn, collectionID, profileID, keyword, recommendCount, recommendList, regDate, apply);
    }

    public static void update(Connection conn, String collectionID, String profileID, String keyword, int recommendCount, String[] recommendList) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        RecommendDB.update(conn, collectionID, profileID, keyword, recommendCount, recommendList, regDate, apply);
    }

    private static void update(Connection conn, String collectionID, String profileID, String keyword, int recommendCount, String[] recommendList, Timestamp regDate, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        if (recommendCount != recommendList.length) {
            throw new IllegalArgumentException("RecommendCount(" + recommendCount + ") does not match to recommendList.length(" + recommendList.length + ")");
        }
        String recommendListString = RecommendDB.makeRecommendList(recommendList);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("RECOMMEND_COUNT", 1, recommendCount), new RdbmsStringColumnParameter("RECOMMEND_LIST", 2, recommendListString), new RdbmsDateColumnParameter("REG_DATE", 3, regDate), new RdbmsIntColumnParameter("APPLY", 4, apply ? 1 : 0), new RdbmsStringColumnParameter("COLLECTION_ID", 5, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 6, profileID), new RdbmsStringColumnParameter("KEYWORD", 7, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_RECOMMEND, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateApply(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static Recommend get(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_RECOMMEND, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return Recommend.create(native_row);
    }

    public static Recommend[] getListSystem(Connection conn, String order) throws SQLException {
        return RecommendDB.getList(conn, "*", "*", order);
    }

    public static Recommend[] getListCollection(Connection conn, String collectionID, String order) throws SQLException {
        return RecommendDB.getList(conn, collectionID, "*", order);
    }

    public static Recommend[] getList(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        order = RecommendDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_PROFILE_RECOMMEND) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return Recommend.create(list);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int count = RecommendDB.getCount(conn, fromCollectionID, fromProfileID);
        int iterNum = count / 200 + 1;
        int i = 0;
        while (i < iterNum) {
            int start = i * 200 + 1;
            Recommend[] list = RecommendDB.getListPage(conn, fromCollectionID, fromProfileID, start, 200, null);
            int j = 0;
            while (j < list.length) {
                RecommendDB.put(conn, toCollectionID, toProfileID, list[j].getKeyword(), list[j].getRecommendCount(), list[j].getRecommendList());
                ++j;
            }
            ++i;
        }
    }

    public static int getCount(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_RECOMMEND, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSystem(Connection conn) throws SQLException {
        return RecommendDB.getCount(conn, "*", "*");
    }

    public static int getCountDefaultProfile(Connection conn, String collectionID) throws SQLException {
        return RecommendDB.getCount(conn, collectionID, "*");
    }

    public static Recommend[] getListPage(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "RECOMMEND_COUNT", "RECOMMEND_LIST", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Recommend.create(list);
    }

    public static Recommend[] getListPageOrderKeyword(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, "KEYWORD ASC");
    }

    public static Recommend[] getListPageOrderDate(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, "REG_DATE DESC");
    }

    public static Recommend[] getListPageOrderApply(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, "APPLY ASC");
    }

    public static Recommend[] getListPageSystem(Connection conn, int start, int scale, String order) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, order);
    }

    public static Recommend[] getListPageSystemOrderKeyword(Connection conn, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, "KEYWORD ASC");
    }

    public static Recommend[] getListPageSystemOrderDate(Connection conn, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, "REG_DATE DESC");
    }

    public static Recommend[] getListPageSystemOrderApply(Connection conn, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, "*", "*", start, scale, "APPLY ASC");
    }

    public static Recommend[] getListPageDefaultProfile(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return RecommendDB.getListPage(conn, collectionID, "*", start, scale, order);
    }

    public static Recommend[] getListPageDefaultProfileOrderKeyword(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, collectionID, "*", start, scale, "KEYWORD ASC");
    }

    public static Recommend[] getListPageDefaultProfileOrderDate(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, collectionID, "*", start, scale, "REG_DATE DESC");
    }

    public static Recommend[] getListPageDefaultProfileOrderApply(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return RecommendDB.getListPage(conn, collectionID, "*", start, scale, "APPLY ASC");
    }

    public static int getCountSearch(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static Recommend[] getListSearchPage(Connection conn, String collectionID, String profileID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "RECOMMEND_COUNT", "RECOMMEND_LIST", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Recommend.create(list);
    }

    public static void delete(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RecommendDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_RECOMMEND, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteSystem(Connection conn) throws SQLException {
        RecommendDB.deleteProfile(conn, "*", "*");
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID) throws SQLException {
        RecommendDB.deleteProfile(conn, collectionID, "*");
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                RecommendDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

