/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.redirect.Redirect;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsRawParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class RedirectDB
extends DBHandler
implements CollectionObservable {
    static final String TABLE = String.valueOf(PREFIX) + "_REDIRECT";
    static final String ALL_COLUMN_REDIRECT = "COLLECTION_ID, PROFILE_ID, KEYWORD, THEME_TITLE, AUTHOR, START_DATE, END_DATE, REDIRECT_URL, REG_DATE, APPLY";
    static final String SQL_INSERT_REDIRECT = " INSERT INTO " + TABLE + " (" + "COLLECTION_ID, PROFILE_ID, KEYWORD, THEME_TITLE, AUTHOR, START_DATE, END_DATE, REDIRECT_URL, REG_DATE, APPLY" + ") " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
    static final String SQL_SELECT_PROFILE = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, THEME_TITLE, AUTHOR, START_DATE, END_DATE, REDIRECT_URL, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_KEYWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, THEME_TITLE, AUTHOR, START_DATE, END_DATE, REDIRECT_URL, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_SELECT_THEME = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, THEME_TITLE, AUTHOR, START_DATE, END_DATE, REDIRECT_URL, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THEME_TITLE = ? ";
    static final String SQL_SELECT_COUNT_PROFILE = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_COUNT_KEYWORD = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ? ";
    static final String SQL_SELECT_COUNT_THEME = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THEME_TITLE LIKE ? ";
    static final String SQL_UPDATE_REDIRECT = " UPDATE " + TABLE + " SET KEYWORD=?, AUTHOR=?, START_DATE=?, END_DATE=?, REDIRECT_URL=?, REG_DATE=?, APPLY=?" + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THEME_TITLE = ? ";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_PROFILE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_KEYWORD = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_DELETE_THEME = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THEME_TITLE = ? ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_EXPIRED = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND END_DATE != 0 AND END_DATE < ?";

    public static void put(Connection conn, Redirect redirect) throws SQLException {
        String collectionID = redirect.getCollectionID();
        String profileID = redirect.getProfileID();
        String keywordSet = redirect.getKeyword();
        String themeTitle = redirect.getThemeTitle();
        String author = redirect.getAuthor();
        long start = redirect.getStart();
        long end = redirect.getEnd();
        String redirectURL = redirect.getRedirectURL();
        boolean apply = false;
        RedirectDB.put(conn, collectionID, profileID, keywordSet, themeTitle, author, start, end, redirectURL, apply);
    }

    public static void put(Connection conn, String collectionID, String profileID, String keywordSet, String themeTitle, String author, long start, long end, String redirectURL) throws SQLException {
        RedirectDB.put(conn, collectionID, profileID, keywordSet, themeTitle, author, start, end, redirectURL, false);
    }

    private static void put(Connection conn, String collectionID, String profileID, String keywordSet, String themeTitle, String author, long start, long end, String redirectURL, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keywordSet)) {
            keywordSet = "*";
        }
        if (StringUtil.isEmpty((String)themeTitle)) {
            throw new SQLException("Theme Title is null.");
        }
        keywordSet = RedirectDB.toUpperTrim(keywordSet);
        themeTitle = RedirectDB.toUpperTrim(themeTitle);
        author = author.trim();
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keywordSet), new RdbmsStringColumnParameter("THEME_TITLE", 4, themeTitle), new RdbmsStringColumnParameter("AUTHOR", 5, author), new RdbmsLongColumnParameter("START_DATE", 6, start), new RdbmsLongColumnParameter("END_DATE", 7, end), new RdbmsStringColumnParameter("REDIRECT_URL", 8, redirectURL), new RdbmsDateColumnParameter("REG_DATE", 9, regDate), new RdbmsIntColumnParameter("APPLY", 10, apply ? 1 : 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_REDIRECT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void update(Connection conn, Redirect redirect) throws SQLException {
        String collectionID = redirect.getCollectionID();
        String profileID = redirect.getProfileID();
        String keyword = redirect.getKeyword();
        String themeTitle = redirect.getThemeTitle();
        String author = redirect.getAuthor();
        long start = redirect.getStart();
        long end = redirect.getEnd();
        String redirectURL = redirect.getRedirectURL();
        RedirectDB.update(conn, collectionID, profileID, keyword, themeTitle, author, start, end, redirectURL, false);
    }

    public static void update(Connection conn, String collectionID, String profileID, String keywordSet, String themeTitle, String author, long start, long end, String redirectURL) throws SQLException {
        RedirectDB.update(conn, collectionID, profileID, keywordSet, themeTitle, author, start, end, redirectURL, false);
    }

    private static void update(Connection conn, String collectionID, String profileID, String keywordSet, String themeTitle, String author, long start, long end, String redirectURL, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keywordSet)) {
            keywordSet = "*";
        }
        if (StringUtil.isEmpty((String)themeTitle)) {
            throw new SQLException("ThemeTitle is null.");
        }
        keywordSet = RedirectDB.toUpperTrim(keywordSet);
        themeTitle = RedirectDB.toUpperTrim(themeTitle);
        author = author.trim();
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("KEYWORD", 1, keywordSet), new RdbmsStringColumnParameter("AUTHOR", 2, author), new RdbmsLongColumnParameter("START_DATE", 3, start), new RdbmsLongColumnParameter("END_DATE", 4, end), new RdbmsStringColumnParameter("REDIRECT_URL", 5, redirectURL), new RdbmsDateColumnParameter("REG_DATE", 6, regDate), new RdbmsIntColumnParameter("APPLY", 7, apply ? 1 : 0), new RdbmsStringColumnParameter("COLLECTION_ID", 8, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 9, profileID), new RdbmsStringColumnParameter("THEME_TITLE", 10, themeTitle)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_REDIRECT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateApply(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static Redirect get(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RedirectDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_KEYWORD, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return Redirect.create(native_row);
    }

    public static Redirect getTheme(Connection conn, String collectionID, String profileID, String theme) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)theme)) {
            throw new SQLException("Theme is null.");
        }
        theme = RedirectDB.toUpperTrim(theme);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THEME_TITLE", 3, theme)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_THEME, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return Redirect.create(native_row);
    }

    public static Redirect[] getListSystem(Connection conn, String order) throws SQLException {
        return RedirectDB.getList(conn, "*", "*", order);
    }

    public static Redirect[] getListCollection(Connection conn, String collectionID, String order) throws SQLException {
        return RedirectDB.getList(conn, collectionID, "*", order);
    }

    public static Redirect[] getList(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        order = RedirectDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_PROFILE) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return Redirect.create(list);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int count = RedirectDB.getCount(conn, fromCollectionID, fromProfileID);
        int iterNum = count / 200 + 1;
        int i = 0;
        while (i < iterNum) {
            int start = i * 200 + 1;
            Redirect[] list = RedirectDB.getListPage(conn, fromCollectionID, fromProfileID, start, 200, null);
            int j = 0;
            while (j < list.length) {
                RedirectDB.put(conn, toCollectionID, toProfileID, list[j].getKeyword(), list[j].getThemeTitle(), list[j].getAuthor(), list[j].getStart(), list[j].getEnd(), list[j].getRedirectURL());
                ++j;
            }
            ++i;
        }
    }

    public static int getCountSystem(Connection conn) throws SQLException {
        return RedirectDB.getCount(conn, "*", "*");
    }

    public static int getCountDefaultProfile(Connection conn, String collectionID) throws SQLException {
        return RedirectDB.getCount(conn, collectionID, "*");
    }

    public static int getCount(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_PROFILE, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearch(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RedirectDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_KEYWORD, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearchTheme(Connection conn, String collectionID, String profileID, String themeTitle) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)themeTitle)) {
            throw new SQLException("ThemeTitle is null.");
        }
        themeTitle = RedirectDB.toUpperTrim(themeTitle);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THEME_TITLE", 3, "%" + themeTitle + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_THEME, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCount(Connection conn, String collectionID, String profileID, boolean expire) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String currentDate = String.valueOf(System.currentTimeMillis());
        String compare = expire ? " AND END_DATE != 0 AND END_DATE < " + currentDate : " AND END_DATE = 0 OR END_DATE >= " + currentDate;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_COUNT_PROFILE) + compare, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearch(Connection conn, String collectionID, String profileID, boolean expire, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RedirectDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String currentDate = String.valueOf(System.currentTimeMillis());
        String compare = expire ? " AND END_DATE != 0 AND END_DATE < " + currentDate : " AND END_DATE = 0 OR END_DATE >= " + currentDate;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_COUNT_KEYWORD) + compare, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearchTheme(Connection conn, String collectionID, String profileID, boolean expire, String theme) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)theme)) {
            throw new SQLException("Theme title is null.");
        }
        theme = RedirectDB.toUpperTrim(theme);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String currentDate = String.valueOf(System.currentTimeMillis());
        String compare = expire ? " AND END_DATE != 0 AND END_DATE < " + currentDate : " AND END_DATE = 0 OR END_DATE >= " + currentDate;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THEME_TITLE", 3, "%" + theme + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_COUNT_THEME) + compare, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static Redirect[] getListPage(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "THEME_TITLE", "AUTHOR", "START_DATE", "END_DATE", "REDIRECT_URL", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("THEME_TITLE", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Redirect.create(list);
    }

    public static Redirect[] getListSearchPage(Connection conn, String collectionID, String profileID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RedirectDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "THEME_TITLE", "AUTHOR", "START_DATE", "END_DATE", "REDIRECT_URL", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("THEME_TITLE", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Redirect.create(list);
    }

    public static Redirect[] getListSearchPageTheme(Connection conn, String collectionID, String profileID, String themeTitle, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)themeTitle)) {
            throw new SQLException("Theme title is null.");
        }
        themeTitle = RedirectDB.toUpperTrim(themeTitle);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "THEME_TITLE", "AUTHOR", "START_DATE", "END_DATE", "REDIRECT_URL", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THEME_TITLE LIKE", 3, "%" + themeTitle + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("THEME_TITLE", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Redirect.create(list);
    }

    public static Redirect[] getListPage(Connection conn, String collectionID, String profileID, boolean expire, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "THEME_TITLE", "AUTHOR", "START_DATE", "END_DATE", "REDIRECT_URL", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        String compare = expire ? "END_DATE != 0 AND END_DATE < " : "END_DATE = 0 OR END_DATE >= ";
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsRawParameter(compare, 3, String.valueOf(System.currentTimeMillis()))};
        RdbmsPagingQuery query = new RdbmsPagingQuery("THEME_TITLE", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Redirect.create(list);
    }

    public static Redirect[] getListSearchPage(Connection conn, String collectionID, String profileID, String keyword, boolean expire, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "THEME_TITLE", "AUTHOR", "START_DATE", "END_DATE", "REDIRECT_URL", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        String compare = expire ? "END_DATE != 0 AND END_DATE < " : "END_DATE = 0 OR END_DATE >= ";
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%"), new RdbmsRawParameter(compare, 4, String.valueOf(System.currentTimeMillis()))};
        RdbmsPagingQuery query = new RdbmsPagingQuery("THEME_TITLE", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Redirect.create(list);
    }

    public static Redirect[] getListPageOrderKeyword(Connection conn, String collectionID, String profileID, boolean expire, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, profileID, expire, start, scale, "KEYWORD ASC");
    }

    public static Redirect[] getListPageOrderDate(Connection conn, String collectionID, String profileID, boolean expire, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, profileID, expire, start, scale, "REG_DATE DESC");
    }

    public static Redirect[] getListPageOrderApply(Connection conn, String collectionID, String profileID, boolean expire, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, profileID, expire, start, scale, "APPLY ASC");
    }

    public static Redirect[] getListPageOrderKeyword(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, profileID, start, scale, "KEYWORD ASC");
    }

    public static Redirect[] getListPageOrderDate(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, profileID, start, scale, "REG_DATE DESC");
    }

    public static Redirect[] getListPageOrderApply(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, profileID, start, scale, "APPLY ASC");
    }

    public static Redirect[] getListPageSystem(Connection conn, int start, int scale, String order) throws SQLException {
        return RedirectDB.getListPage(conn, "*", "*", start, scale, order);
    }

    public static Redirect[] getListPageSystemOrderKeyword(Connection conn, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, "*", "*", start, scale, "KEYWORD ASC");
    }

    public static Redirect[] getListPageSystemOrderDate(Connection conn, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, "*", "*", start, scale, "REG_DATE DESC");
    }

    public static Redirect[] getListPageSystemOrderApply(Connection conn, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, "*", "*", start, scale, "APPLY ASC");
    }

    public static Redirect[] getListPageDefaultProfile(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, "*", start, scale, order);
    }

    public static Redirect[] getListPageDefaultProfileOrderKeyword(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, "*", start, scale, "KEYWORD ASC");
    }

    public static Redirect[] getListPageDefaultProfileOrderDate(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, "*", start, scale, "REG_DATE DESC");
    }

    public static Redirect[] getListPageDefaultProfileOrderApply(Connection conn, String collectionID, int start, int scale) throws SQLException {
        return RedirectDB.getListPage(conn, collectionID, "*", start, scale, "APPLY ASC");
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteSystem(Connection conn) throws SQLException {
        RedirectDB.deleteProfile(conn, "*", "*");
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID) throws SQLException {
        RedirectDB.deleteProfile(conn, collectionID, "*");
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void delete(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = RedirectDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteTheme(Connection conn, String collectionID, String profileID, String themeTitle) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)themeTitle)) {
            throw new SQLException("Theme Title is null.");
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THEME_TITLE", 3, themeTitle)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_THEME, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteExpired(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        long currentTime = System.currentTimeMillis();
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsLongColumnParameter("END_DATE", 3, currentTime)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_EXPIRED, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                RedirectDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

