/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.stopword.Stopword;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class StopwordDB
extends DBHandler
implements CollectionObservable {
    static final String TABLE = String.valueOf(PREFIX) + "_STOPWORD";
    static final String SQL_INSERT_STOPWORD = " INSERT INTO " + TABLE + " (COLLECTION_ID, PROFILE_ID, FIELD, KEYWORD, REG_DATE, APPLY) VALUES ( ?, ?, ?, ?, ?, ?)";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_STOPWORD = " SELECT COLLECTION_ID, PROFILE_ID, FIELD, KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND FIELD = ? AND KEYWORD = ?";
    static final String SQL_SELECT_PROFILE_STOPWORD = " SELECT COLLECTION_ID, PROFILE_ID, FIELD, KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_FIELD_STOPWORD = " SELECT COLLECTION_ID, PROFILE_ID, FIELD, KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND FIELD = ?";
    static final String SQL_SEARCH_STOPWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_SELECT_COUNT_PROFILE = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_COUNT_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_SELECT_COUNT_FIELDSTOPWORD = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND FIELD = ?";
    static final String SQL_SELECT_COUNT_FIELDSTOPWORD_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND FIELD = ? AND KEYWORD LIKE ?";
    static final String SQL_DELETE_STOPWORD = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND FIELD = ? AND KEYWORD = ?";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_PROFILE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";

    public static void put(Connection conn, String collectionID, String profileID, String fieldID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            fieldID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        if (profileID != null && !profileID.equals("*") && fieldID != null && !fieldID.equals("*")) {
            throw new SQLException("Cannot insert FieldStopword to profile [fieldID : " + fieldID + "] [profileID : " + profileID + "]");
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                Timestamp regDate = new Timestamp(System.currentTimeMillis());
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("FIELD", 3, fieldID), new RdbmsStringColumnParameter("KEYWORD", 4, keyword), new RdbmsDateColumnParameter("REG_DATE", 5, regDate), new RdbmsIntColumnParameter("APPLY", 6, 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_STOPWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void putFieldStopword(Connection conn, String collectionID, String fieldID, String keyword) throws SQLException {
        StopwordDB.put(conn, collectionID, "*", fieldID, keyword);
    }

    public static void put(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        StopwordDB.put(conn, collectionID, profileID, "*", keyword);
    }

    public static void updateApply(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static Stopword get(Connection conn, String collectionID, String profileID, String fieldID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            fieldID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("FIELD", 3, fieldID), new RdbmsStringColumnParameter("KEYWORD", 4, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_STOPWORD, parameters);
        RdbmsColumnValue[] native_rows = supporter.fetchItem(conn, query);
        return Stopword.create(native_rows);
    }

    public static Stopword get(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return StopwordDB.get(conn, collectionID, profileID, "*", keyword);
    }

    public static Stopword getFieldStopword(Connection conn, String collectionID, String fieldID, String keyword) throws SQLException {
        return StopwordDB.get(conn, collectionID, "*", fieldID, keyword);
    }

    public static Stopword[] getListFieldStopword(Connection conn, String collectionID, String fieldID, String order) throws SQLException {
        order = StopwordDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null.");
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            throw new SQLException("fieldID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, fieldID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_FIELD_STOPWORD, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return Stopword.create(native_rows);
    }

    public static Stopword[] getListSystem(Connection conn, String order) throws SQLException {
        return StopwordDB.getList(conn, "*", "*", order);
    }

    public static Stopword[] getListCollection(Connection conn, String collectionID, String order) throws SQLException {
        return StopwordDB.getList(conn, collectionID, "*", order);
    }

    public static Stopword[] getList(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        order = StopwordDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_PROFILE_STOPWORD) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return Stopword.create(native_rows);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int count = StopwordDB.getCount(conn, fromCollectionID, fromProfileID);
        int iterNum = count / 200 + 1;
        int i = 0;
        while (i < iterNum) {
            int start = i * 200 + 1;
            Stopword[] list = StopwordDB.getListPage(conn, fromCollectionID, fromProfileID, start, 200, null);
            int j = 0;
            while (j < list.length) {
                StopwordDB.put(conn, toCollectionID, toProfileID, list[j].getField(), list[j].getKeyword());
                ++j;
            }
            ++i;
        }
    }

    public static int getCountSystem(Connection conn) throws SQLException {
        return StopwordDB.getCount(conn, "*", "*");
    }

    public static int getCountCollection(Connection conn, String collectionID) throws SQLException {
        return StopwordDB.getCount(conn, collectionID, "*");
    }

    public static int getCount(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_PROFILE, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearch(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getFieldStopwordCount(Connection conn, String collectionID, String fieldID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            throw new SQLException("fieldID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, "*"), new RdbmsStringColumnParameter("FIELD", 3, fieldID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_FIELDSTOPWORD, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getFieldStopwordCountSearch(Connection conn, String collectionID, String fieldID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            throw new SQLException("fieldID is null.");
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, "*"), new RdbmsStringColumnParameter("FIELD", 3, fieldID), new RdbmsStringColumnParameter("KEYWORD", 4, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_FIELDSTOPWORD_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static Stopword[] getListPage(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "FIELD", "KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Stopword.create(list);
    }

    public static Stopword[] getListFieldStopwordPage(Connection conn, String collectionID, String fieldID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            throw new SQLException("fieldID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "FIELD", "KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, fieldID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Stopword.create(list);
    }

    public static Stopword[] getListSearchPage(Connection conn, String collectionID, String profileID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "FIELD", "KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Stopword.create(list);
    }

    public static Stopword[] getListFieldStopwordSearchPage(Connection conn, String collectionID, String fieldID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            throw new SQLException("fieldID is null.");
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "FIELD", "KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, fieldID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Stopword.create(list);
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID) throws SQLException {
        StopwordDB.deleteProfile(conn, collectionID, "*");
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void delete(Connection conn, String collectionID, String profileID, String fieldID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)fieldID)) {
            fieldID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = StopwordDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("FIELD", 3, fieldID), new RdbmsStringColumnParameter("KEYWORD", 4, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_STOPWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteFieldStopword(Connection conn, String collectionID, String fieldID, String keyword) throws SQLException {
        StopwordDB.delete(conn, collectionID, null, fieldID, keyword);
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                StopwordDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

