/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.thesaurus.Thesaurus;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.common.StringTokenizer;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class ThesaurusDB
extends DBHandler
implements CollectionObservable {
    static final char DELIMETER = ',';
    static final String TABLE = String.valueOf(PREFIX) + "_THESAURUS";
    static final String SQL_INSERT_THESAURUS = " INSERT INTO " + TABLE + " (COLLECTION_ID, PROFILE_ID, THESAURUS_ID, KEYWORD, THESAURUS_COUNT, THESAURUS_LIST, REG_DATE, APPLY) VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )";
    static final String SQL_SELECT_THESAURUS = " SELECT COLLECTION_ID, PROFILE_ID, THESAURUS_ID, KEYWORD, THESAURUS_COUNT, THESAURUS_LIST, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ? AND KEYWORD = ?";
    static final String SQL_SELECT_THESAURUSES_ALL = " SELECT COLLECTION_ID, PROFILE_ID, THESAURUS_ID, KEYWORD, THESAURUS_COUNT, THESAURUS_LIST, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_THESAURUSES = " SELECT COLLECTION_ID, PROFILE_ID, THESAURUS_ID, KEYWORD, THESAURUS_COUNT, THESAURUS_LIST, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ?";
    static final String SQL_SELECT_COUNT_THESAURUS = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ?";
    static final String SQL_SELECT_COUNT = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ? AND KEYWORD LIKE ? ";
    static final String SQL_UPDATE = " UPDATE " + TABLE + " SET THESAURUS_COUNT=?, THESAURUS_LIST=?, REG_DATE=?, APPLY=? WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ? AND KEYWORD = ?";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ? ";
    static final String SQL_DELETE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ? AND KEYWORD = ?";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_COLLECTION_ALL = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND THESAURUS_ID = ? ";
    static final String SQL_DELETE_PROFILE_THESAURUSES_ALL = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_PROFILE_THESAURUSES = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND THESAURUS_ID = ? ";

    public static String makeThesaurusList(String[] keyword) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < keyword.length) {
            buf.append(StringUtil.removeWhitespaces((String)keyword[i]));
            if (i + 1 != keyword.length) {
                buf.append(',');
            }
            ++i;
        }
        return ThesaurusDB.toUpperTrim(buf.toString());
    }

    public static String[] makeThesaurusList(String keyword) {
        char[][] tokens = StringTokenizer.token((String)StringUtil.removeWhitespaces((String)keyword), (char)',');
        String[] tokenStrs = new String[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            tokenStrs[i] = new String(tokens[i]);
            ++i;
        }
        return tokenStrs;
    }

    public static void putFullDuplex(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword, String[] keywords) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        ThesaurusDB.put(conn, collectionID, profileID, thesaurusID, keyword, keywords);
        String[] putKeywords = new String[keywords.length];
        System.arraycopy(keywords, 0, putKeywords, 0, keywords.length);
        int i = 0;
        while (i < keywords.length) {
            String currentKeyword = keywords[i];
            putKeywords[i] = keyword;
            Thesaurus thesaurus = ThesaurusDB.get(conn, collectionID, profileID, thesaurusID, currentKeyword);
            if (thesaurus == null) {
                ThesaurusDB.put(conn, collectionID, profileID, thesaurusID, currentKeyword, putKeywords);
            } else {
                String[] thesauruses = thesaurus.getKeywords();
                String[] merged = ThesaurusDB.mergeStrings(thesauruses, putKeywords);
                thesaurus.setKeywords(merged);
                thesaurus.setThesaurusID(thesaurusID);
                thesaurus.setThesaurusCount(merged.length);
                thesaurus.setRegDate(System.currentTimeMillis());
                thesaurus.setApply(false);
                ThesaurusDB.update(conn, thesaurus);
            }
            putKeywords[i] = keywords[i];
            ++i;
        }
    }

    public static void put(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword, String[] keywords) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        int thesaurusCount = keywords.length;
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD", 4, keyword), new RdbmsIntColumnParameter("THESAURUS_COUNT", 5, thesaurusCount), new RdbmsStringColumnParameter("THESAURUS_LIST", 6, ThesaurusDB.makeThesaurusList(keywords)), new RdbmsDateColumnParameter("REG_DATE", 7, new Timestamp(System.currentTimeMillis())), new RdbmsIntColumnParameter("APPLY", 8, 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_THESAURUS, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void put(Connection conn, Thesaurus thesaurus) throws SQLException {
        String collectionID = thesaurus.getCollectionID();
        String profileID = thesaurus.getProfileID();
        String keyword = thesaurus.getKeyword();
        int thesaurusCount = thesaurus.getThesaurusCount();
        String[] keywords = thesaurus.getKeywords();
        long regDate = thesaurus.getRegDate();
        boolean apply = thesaurus.isApply();
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsIntColumnParameter("THESAURUS_COUNT", 4, thesaurusCount), new RdbmsStringColumnParameter("THESAURUS_LIST", 5, ThesaurusDB.makeThesaurusList(keywords)), new RdbmsDateColumnParameter("REG_DATE", 6, new Timestamp(regDate)), new RdbmsIntColumnParameter("APPLY", 7, apply ? 1 : 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_THESAURUS, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void putSystem(Connection conn, byte thesaurusID, String keyword, String[] keywords) throws SQLException {
        ThesaurusDB.put(conn, "*", "*", thesaurusID, keyword, keywords);
    }

    public static void putCollection(Connection conn, byte thesaurusID, String collectionID, String keyword, String[] keywords) throws SQLException {
        ThesaurusDB.put(conn, collectionID, "*", thesaurusID, keyword, keywords);
    }

    public static Thesaurus get(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD", 4, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_THESAURUS, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return Thesaurus.create(item);
    }

    public static Thesaurus getSystemThesaurus(Connection conn, byte thesaurusID, String keyword) throws SQLException {
        return ThesaurusDB.get(conn, "*", "*", thesaurusID, keyword);
    }

    public static Thesaurus getCollectionThesaurus(Connection conn, String collectionID, byte thesaurusID, String keyword) throws SQLException {
        return ThesaurusDB.get(conn, collectionID, "*", thesaurusID, keyword);
    }

    public static Thesaurus[] getList(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        order = ThesaurusDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_THESAURUSES_ALL) + order, parameters);
        List items = supporter.fetchItems(conn, query);
        return Thesaurus.create(items);
    }

    public static Thesaurus[] getList(Connection conn, String collectionID, String profileID, byte thesaurusID, String order) throws SQLException {
        order = ThesaurusDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_THESAURUSES) + order, parameters);
        List items = supporter.fetchItems(conn, query);
        return Thesaurus.create(items);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, byte fromThesaurusID, String toCollectionID, String toProfileID, byte toThesaurusID) throws SQLException {
        int count = ThesaurusDB.getCount(conn, fromCollectionID, fromProfileID, fromThesaurusID);
        int iterNum = count / 200 + 1;
        int i = 0;
        while (i < iterNum) {
            int start = i * 200 + 1;
            Thesaurus[] list = ThesaurusDB.getListPage(conn, fromCollectionID, fromProfileID, fromThesaurusID, start, 200, null);
            int j = 0;
            while (j < list.length) {
                ThesaurusDB.put(conn, toCollectionID, toProfileID, toThesaurusID, list[j].getKeyword(), list[j].getKeywords());
                ++j;
            }
            ++i;
        }
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int count = ThesaurusDB.getCount(conn, fromCollectionID, fromProfileID);
        int iterNum = count / 200 + 1;
        int i = 0;
        while (i < iterNum) {
            int start = i * 200 + 1;
            Thesaurus[] list = ThesaurusDB.getListPage(conn, fromCollectionID, fromProfileID, start, 200, null);
            int j = 0;
            while (j < list.length) {
                ThesaurusDB.put(conn, toCollectionID, toProfileID, list[j].getThesaurusID(), list[j].getKeyword(), list[j].getKeywords());
                ++j;
            }
            ++i;
        }
    }

    public static Thesaurus[] getListSystem(Connection conn, byte thesaurusID, String order) throws SQLException {
        return ThesaurusDB.getList(conn, "*", "*", thesaurusID, order);
    }

    public static Thesaurus[] getListCollection(Connection conn, String collectionID, byte thesaurusID, String order) throws SQLException {
        return ThesaurusDB.getList(conn, collectionID, "*", thesaurusID, order);
    }

    public static Thesaurus[] getListPage(Connection conn, String collectionID, String profileID, byte thesaurusID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "THESAURUS_ID", "KEYWORD", "THESAURUS_COUNT", "THESAURUS_LIST", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID))};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Thesaurus.create(list);
    }

    public static Thesaurus[] getListPage(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "THESAURUS_ID", "KEYWORD", "THESAURUS_COUNT", "THESAURUS_LIST", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Thesaurus.create(list);
    }

    public static Thesaurus[] getListSearchPage(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "THESAURUS_ID", "KEYWORD", "THESAURUS_COUNT", "THESAURUS_LIST", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD LIKE", 4, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return Thesaurus.create(list);
    }

    public static int getCount(Connection conn, String collectionID, String profileID, byte thesaurusID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_THESAURUS, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCount(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearch(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD", 4, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static void update(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword, String[] keywords) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        int thesaurusCount = keywords.length;
        String thesauruses = ThesaurusDB.makeThesaurusList(keywords);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("THESAURUS_COUNT", 1, thesaurusCount), new RdbmsStringColumnParameter("THESAURUS_LIST", 2, thesauruses), new RdbmsDateColumnParameter("REG_DATE", 3, new Timestamp(System.currentTimeMillis())), new RdbmsIntColumnParameter("APPLY", 4, 0), new RdbmsStringColumnParameter("COLLECTION_ID", 5, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 6, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 7, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD", 8, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void update(Connection conn, Thesaurus thesaurus) throws SQLException {
        String collectionID = thesaurus.getCollectionID();
        String profileID = thesaurus.getProfileID();
        byte thesaurusID = thesaurus.getThesaurusID();
        String keyword = thesaurus.getKeyword();
        int thesaurusCount = thesaurus.getThesaurusCount();
        String[] keywords = thesaurus.getKeywords();
        long regDate = thesaurus.getRegDate();
        boolean apply = thesaurus.isApply();
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("THESAURUS_COUNT", 1, thesaurusCount), new RdbmsStringColumnParameter("THESAURUS_LIST", 2, ThesaurusDB.makeThesaurusList(keywords)), new RdbmsDateColumnParameter("REG_DATE", 3, new Timestamp(regDate)), new RdbmsIntColumnParameter("APPLY", 4, apply ? 1 : 0), new RdbmsStringColumnParameter("COLLECTION_ID", 5, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 6, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 7, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD", 8, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateFullDuplex(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword, String[] keywords) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        ThesaurusDB.update(conn, collectionID, profileID, thesaurusID, keyword, keywords);
        String[] putKeywords = new String[keywords.length];
        System.arraycopy(keywords, 0, putKeywords, 0, keywords.length);
        int i = 0;
        while (i < keywords.length) {
            String currentKeyword = keywords[i];
            putKeywords[i] = keyword;
            Thesaurus thesaurus = ThesaurusDB.get(conn, collectionID, profileID, thesaurusID, currentKeyword);
            if (thesaurus == null) {
                ThesaurusDB.put(conn, collectionID, profileID, thesaurusID, currentKeyword, new String[]{keyword});
            } else {
                String[] thesauruses = thesaurus.getKeywords();
                String[] merged = ThesaurusDB.mergeStrings(thesauruses, putKeywords);
                thesaurus.setKeywords(merged);
                thesaurus.setThesaurusCount(merged.length);
                thesaurus.setRegDate(System.currentTimeMillis());
                thesaurus.setApply(false);
                ThesaurusDB.update(conn, thesaurus);
            }
            ++i;
        }
    }

    public static void updateToOneWay(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword, String[] keywords) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        ThesaurusDB.update(conn, collectionID, profileID, thesaurusID, keyword, keywords);
        int i = 0;
        while (i < keywords.length) {
            String currentKeyword = keywords[i];
            Thesaurus thesaurus = ThesaurusDB.get(conn, collectionID, profileID, thesaurusID, currentKeyword);
            if (thesaurus != null) {
                String[] thesauruses = thesaurus.getKeywords();
                int foundCount = 0;
                int j = 0;
                while (j < thesauruses.length) {
                    if (currentKeyword.equals(thesauruses[j]) && j + ++foundCount < thesauruses.length) {
                        thesauruses[j] = thesauruses[j + foundCount];
                    }
                    ++j;
                }
                if (foundCount > 0) {
                    String[] nThesauruses = new String[thesauruses.length - foundCount];
                    System.arraycopy(thesauruses, 0, nThesauruses, 0, thesauruses.length - foundCount);
                    thesaurus.setKeywords(nThesauruses);
                    thesaurus.setThesaurusCount(nThesauruses.length);
                    thesaurus.setRegDate(System.currentTimeMillis());
                    thesaurus.setApply(false);
                    ThesaurusDB.update(conn, thesaurus);
                }
            }
            ++i;
        }
    }

    public static void updateApply(Connection conn, String collectionID, String profileID, byte thesaurusID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void delete(Connection conn, String collectionID, String profileID, byte thesaurusID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = ThesaurusDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID)), new RdbmsStringColumnParameter("KEYWORD", 4, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteSystemThesaurus(Connection conn, byte thesaurusID) throws SQLException {
        ThesaurusDB.deleteProfile(conn, "*", "*", thesaurusID);
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID, byte thesaurusID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("colletionID is null.");
        }
        ThesaurusDB.deleteProfile(conn, collectionID, "*", thesaurusID);
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("colletionID is null.");
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION_ALL, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID, byte thesaurusID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("colletionID is null.");
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("THESAURUS_ID", 2, Byte.toString(thesaurusID))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_PROFILE_THESAURUSES_ALL, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID, byte thesaurusID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("THESAURUS_ID", 3, Byte.toString(thesaurusID))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_PROFILE_THESAURUSES, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static String[] mergeStrings(String[] input1, String[] input2) {
        int[] meta1 = ArrayUtil.metaSort((Comparable[])input1);
        int[] meta2 = ArrayUtil.metaSort((Comparable[])input2);
        String[] result = new String[input1.length + input2.length];
        int i1 = 0;
        int i2 = 0;
        int outputIndex = 0;
        while (i1 < input1.length || i2 < input2.length) {
            int compare = 0;
            if (i1 >= input1.length) {
                compare = 1;
            } else if (i2 >= input2.length) {
                compare = -1;
            } else {
                String is1 = input1[meta1[i1]];
                String is2 = input2[meta2[i2]];
                compare = is1.compareTo(is2);
            }
            if (compare < 0) {
                result[outputIndex] = input1[meta1[i1]];
                ++outputIndex;
                ++i1;
                continue;
            }
            if (compare > 0) {
                result[outputIndex] = input2[meta2[i2]];
                ++outputIndex;
                ++i2;
                continue;
            }
            result[outputIndex] = input1[meta1[i1]];
            ++outputIndex;
            ++i1;
            ++i2;
        }
        if (result.length > outputIndex) {
            String[] oldArray = result;
            result = new String[outputIndex];
            System.arraycopy(oldArray, 0, result, 0, outputIndex);
        }
        return result;
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection, byte thesaurusID) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                ThesaurusDB.deleteCollection(conn, collection, thesaurusID);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                ThesaurusDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

