/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.SqlAppendUtil;
import com.diquest.ir.common.database.entity.feedback.FeedbackStatisticEntity;
import com.diquest.ir.common.database.handler.Pageable;
import com.diquest.ir.common.database.handler.feedback.AbstractFeedbackDB;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractFeedbackStatisticsDB
extends AbstractFeedbackDB
implements Pageable {
    static final int DISABLED = -1;
    private int offset = 1;
    private int limit = 1000;
    protected static final String COLLECTION_NAME = "COLLECTION_NAME";
    protected static final String PROFILE_NAME = "PROFILE_NAME";
    protected static final String KEYWORD = "KEYWORD";
    protected static final String FUNCTION01_CNT = "FUNCTION01_CNT";
    protected static final String FUNCTION02_CNT = "FUNCTION02_CNT";
    protected static final String FUNCTION03_CNT = "FUNCTION03_CNT";
    protected static final String FUNCTION04_CNT = "FUNCTION04_CNT";
    protected static final String FUNCTION05_CNT = "FUNCTION05_CNT";
    protected static final String FUNCTION06_CNT = "FUNCTION06_CNT";
    protected static final String FUNCTION07_CNT = "FUNCTION07_CNT";
    protected static final String FUNCTION08_CNT = "FUNCTION08_CNT";
    protected static final String FUNCTION09_CNT = "FUNCTION09_CNT";
    protected static final String FUNCTION10_CNT = "FUNCTION10_CNT";
    protected static final String FUNCTION11_CNT = "FUNCTION11_CNT";
    protected static final String FUNCTION12_CNT = "FUNCTION12_CNT";
    protected static final String FUNCTION13_CNT = "FUNCTION13_CNT";
    protected static final String FUNCTION14_CNT = "FUNCTION14_CNT";
    protected static final String FUNCTION15_CNT = "FUNCTION15_CNT";
    protected static final String FUNCTION16_CNT = "FUNCTION16_CNT";
    protected static final String FUNCTION17_CNT = "FUNCTION17_CNT";
    protected static final String FUNCTION18_CNT = "FUNCTION18_CNT";
    protected static final String FUNCTION19_CNT = "FUNCTION19_CNT";
    protected static final String FUNCTION20_CNT = "FUNCTION20_CNT";
    protected static final String REG_DATE = "REG_DATE";
    protected static final String UNIT = "UNIT";
    protected static final String[] ID_COLUMNS = new String[]{"FUNCTION01_CNT", "FUNCTION02_CNT", "FUNCTION03_CNT", "FUNCTION04_CNT", "FUNCTION05_CNT", "FUNCTION06_CNT", "FUNCTION07_CNT", "FUNCTION08_CNT", "FUNCTION09_CNT", "FUNCTION10_CNT", "FUNCTION11_CNT", "FUNCTION12_CNT", "FUNCTION13_CNT", "FUNCTION14_CNT", "FUNCTION15_CNT", "FUNCTION16_CNT", "FUNCTION17_CNT", "FUNCTION18_CNT", "FUNCTION19_CNT", "FUNCTION20_CNT"};
    protected static final String[] ALL_COLUMNS = new String[]{"COLLECTION_NAME", "PROFILE_NAME", "KEYWORD", "FUNCTION01_CNT", "FUNCTION02_CNT", "FUNCTION03_CNT", "FUNCTION04_CNT", "FUNCTION05_CNT", "FUNCTION06_CNT", "FUNCTION07_CNT", "FUNCTION08_CNT", "FUNCTION09_CNT", "FUNCTION10_CNT", "FUNCTION11_CNT", "FUNCTION12_CNT", "FUNCTION13_CNT", "FUNCTION14_CNT", "FUNCTION15_CNT", "FUNCTION16_CNT", "FUNCTION17_CNT", "FUNCTION18_CNT", "FUNCTION19_CNT", "FUNCTION20_CNT", "REG_DATE", "UNIT"};
    protected static final String[] SUM_COLUMNS = new String[]{"SUM_FUNC01", "SUM_FUNC02", "SUM_FUNC03", "SUM_FUNC04", "SUM_FUNC05", "SUM_FUNC06", "SUM_FUNC07", "SUM_FUNC08", "SUM_FUNC09", "SUM_FUNC10", "SUM_FUNC11", "SUM_FUNC12", "SUM_FUNC13", "SUM_FUNC14", "SUM_FUNC15", "SUM_FUNC16", "SUM_FUNC17", "SUM_FUNC18", "SUM_FUNC19", "SUM_FUNC20"};
    protected static final String[] SUM_FUNCTIONS_COLUMNS = new String[]{"SUM(FUNCTION01_CNT) as " + SUM_COLUMNS[0], "SUM(FUNCTION02_CNT) as " + SUM_COLUMNS[1], "SUM(FUNCTION03_CNT) as " + SUM_COLUMNS[2], "SUM(FUNCTION04_CNT) as " + SUM_COLUMNS[3], "SUM(FUNCTION05_CNT) as " + SUM_COLUMNS[4], "SUM(FUNCTION06_CNT) as " + SUM_COLUMNS[5], "SUM(FUNCTION07_CNT) as " + SUM_COLUMNS[6], "SUM(FUNCTION08_CNT) as " + SUM_COLUMNS[7], "SUM(FUNCTION09_CNT) as " + SUM_COLUMNS[8], "SUM(FUNCTION10_CNT) as " + SUM_COLUMNS[9], "SUM(FUNCTION11_CNT) as " + SUM_COLUMNS[10], "SUM(FUNCTION12_CNT) as " + SUM_COLUMNS[11], "SUM(FUNCTION13_CNT) as " + SUM_COLUMNS[12], "SUM(FUNCTION14_CNT) as " + SUM_COLUMNS[13], "SUM(FUNCTION15_CNT) as " + SUM_COLUMNS[14], "SUM(FUNCTION16_CNT) as " + SUM_COLUMNS[15], "SUM(FUNCTION17_CNT) as " + SUM_COLUMNS[16], "SUM(FUNCTION18_CNT) as " + SUM_COLUMNS[17], "SUM(FUNCTION19_CNT) as " + SUM_COLUMNS[18], "SUM(FUNCTION20_CNT) as " + SUM_COLUMNS[19], "UNIT"};

    public abstract int excuteWholeFeedbackSave(Connection var1, String var2, String var3, int[] var4) throws SQLException;

    public abstract int excuteKeywordFeedbackSave(Connection var1, String var2, String var3, String var4, int[] var5) throws SQLException;

    public abstract FeedbackStatisticEntity[] excuteSelectAll(Connection var1) throws SQLException;

    public abstract FeedbackStatisticEntity[] excuteSelectConditions(Connection var1, String var2, String var3, String var4) throws SQLException;

    public abstract FeedbackStatisticEntity[] excuteSelectConditionsAfterDate(Connection var1, String var2, String var3, String var4, int var5, boolean var6) throws SQLException;

    public abstract FeedbackStatisticEntity[] excuteSelectConditionsBetweenDate(Connection var1, String var2, String var3, String var4, Date var5, Date var6) throws SQLException;

    public abstract FeedbackStatisticEntity[] excuteSelectConditionsBetweenDate(Connection var1, String var2, String var3, String var4, Date var5, Date var6, boolean var7) throws SQLException;

    public abstract int excuteDeleteFromTodayBeforeDate(Connection var1, int var2) throws SQLException;

    protected int excuteDeleteFromTodayBeforeDate(Connection conn, String deleteSql, int month) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params = this.getDeleteColumnParameter(month);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(deleteSql, params);
        return supporter.executeUpdate(conn, query);
    }

    private RdbmsColumnParameter[] getDeleteColumnParameter(int month) {
        Date currentDate = DateUtil.getStartCurrentDay();
        Date beforeDate = DateUtil.getStartBeforeMonth((Date)currentDate, (int)month);
        RdbmsColumnParameter[] list = new RdbmsColumnParameter[]{new RdbmsLongColumnParameter(UNIT, 1, beforeDate.getTime())};
        return list;
    }

    protected int excuteSave(Connection conn, String insertSql, String collectionName, String profileName, String keywordName, int[] functionCnts) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params = this.getSaveColumnParameter(collectionName, profileName, keywordName, functionCnts);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(insertSql, params);
        return supporter.executeUpdate(conn, query);
    }

    private RdbmsColumnParameter[] getSaveColumnParameter(String collection, String profile, String keyword, int[] functionCnts) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        int idx = 1;
        paramList.add(new RdbmsStringColumnParameter(COLLECTION_NAME, idx++, collection));
        paramList.add(new RdbmsStringColumnParameter(PROFILE_NAME, idx++, profile));
        paramList.add(new RdbmsStringColumnParameter(KEYWORD, idx++, keyword));
        int i = 0;
        while (i < functionCnts.length) {
            paramList.add(new RdbmsIntColumnParameter(ID_COLUMNS[i], idx++, functionCnts[i]));
            ++i;
        }
        paramList.add(new RdbmsDateColumnParameter(REG_DATE, idx++, AbstractFeedbackStatisticsDB.getRegDate()));
        paramList.add(new RdbmsLongColumnParameter(UNIT, idx++, this.getUnit()));
        RdbmsColumnParameter[] list = new RdbmsColumnParameter[paramList.size()];
        paramList.toArray(list);
        return list;
    }

    protected FeedbackStatisticEntity[] excuteSelect(Connection conn, String selectSql, String collection, String profile, String keyword, Date from, Date to) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params = this.getSelectParameter(collection, profile, keyword, from, to);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(selectSql, params);
        return FeedbackStatisticEntity.create(supporter.fetchItems(conn, query));
    }

    protected FeedbackStatisticEntity[] excuteSelect(Connection conn, String selectSql, String collection, String profile, String keyword, Date before) throws SQLException {
        return this.excuteSelect(conn, selectSql, collection, profile, keyword, before, null);
    }

    protected FeedbackStatisticEntity[] excuteSelectAll(Connection conn, String selectSql) throws SQLException {
        return this.excuteSelect(conn, selectSql, null, null, null, null);
    }

    protected String makeSelectWhereSql(String sql, String collectionName, String profileName, String keyword, Date from, Date to, boolean isUnitGroup) {
        StringBuffer sb = new StringBuffer(sql);
        ArrayList<String> groupColumns = new ArrayList<String>();
        boolean isAppendingAnd = false;
        sb.append(" where ");
        if (!StringUtil.isEmpty((String)collectionName)) {
            sb.append(COLLECTION_NAME).append(" = ? ");
            isAppendingAnd = true;
        }
        if (!StringUtil.isEmpty((String)profileName)) {
            if (isAppendingAnd) {
                sb.append(" and ");
            }
            sb.append(PROFILE_NAME).append(" = ? ");
            isAppendingAnd = true;
        }
        if (keyword != null) {
            if (isAppendingAnd) {
                sb.append(" and ");
            }
            sb.append(KEYWORD).append(" = ? ");
            isAppendingAnd = true;
        }
        if (from != null) {
            if (isAppendingAnd) {
                sb.append(" and ");
            }
            sb.append(UNIT).append(" >= ?");
            isAppendingAnd = true;
        }
        if (to != null) {
            if (isAppendingAnd) {
                sb.append(" and ");
            }
            sb.append(UNIT).append(" <= ?");
        }
        if (isUnitGroup) {
            groupColumns.add(UNIT);
        }
        if (groupColumns.size() > 0) {
            String[] columns = new String[groupColumns.size()];
            groupColumns.toArray(columns);
            String group = SqlAppendUtil.appendGroupBy(columns);
            sb.append(group);
        }
        return sb.toString();
    }

    protected String makeSelectWhereSql(String sql, String collectionName, String profileName, String keyword, Date before) {
        return this.makeSelectWhereSql(sql, collectionName, profileName, keyword, before, null, false);
    }

    protected int excuteUpdateOrSave(Connection conn, String chkSql, String insertSql, String updateSql, String collectionName, String profileName, String keywordName, int[] functionCnts) throws SQLException {
        FeedbackStatisticEntity entities = this.chkUpdate(conn, chkSql, collectionName, profileName, keywordName);
        if (entities != null) {
            return this.excuteUpdate(conn, updateSql, entities, functionCnts);
        }
        return this.excuteSave(conn, insertSql, collectionName, profileName, keywordName, functionCnts);
    }

    private int excuteUpdate(Connection conn, String updateSql, FeedbackStatisticEntity entities, int[] functionCnts) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params1 = this.getUpdateColumnParameter(entities, functionCnts);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(updateSql, params1);
        return supporter.executeUpdate(conn, query);
    }

    private RdbmsColumnParameter[] getUpdateColumnParameter(FeedbackStatisticEntity entities, int[] functionCnts) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        int idx = 1;
        int[] preCnts = entities.getFunctionCnt();
        int i = 0;
        while (i < functionCnts.length) {
            paramList.add(new RdbmsIntColumnParameter(ID_COLUMNS[i], idx++, preCnts[i] + functionCnts[i]));
            ++i;
        }
        paramList.add(new RdbmsStringColumnParameter(COLLECTION_NAME, idx++, entities.getCollectionName()));
        paramList.add(new RdbmsStringColumnParameter(PROFILE_NAME, idx++, entities.getProfileName()));
        paramList.add(new RdbmsStringColumnParameter(KEYWORD, idx++, entities.getKeyword()));
        long dayTime = this.getUnit();
        paramList.add(new RdbmsLongColumnParameter(UNIT, idx++, dayTime));
        RdbmsColumnParameter[] list = new RdbmsColumnParameter[paramList.size()];
        paramList.toArray(list);
        return list;
    }

    protected FeedbackStatisticEntity chkUpdate(Connection conn, String baseSql, String collectionName, String profileName, String keyword) throws SQLException {
        String sql = this.makeChkSql(baseSql);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params = this.getUpdateParameter(collectionName, profileName, keyword);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, params);
        return FeedbackStatisticEntity.create(supporter.fetchItem(conn, query));
    }

    private RdbmsColumnParameter[] getUpdateParameter(String collectionName, String profileName, String keyword) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        int idx = 1;
        paramList.add(new RdbmsStringColumnParameter(COLLECTION_NAME, idx++, collectionName));
        paramList.add(new RdbmsStringColumnParameter(PROFILE_NAME, idx++, profileName));
        paramList.add(new RdbmsStringColumnParameter(KEYWORD, idx++, keyword));
        long dayTime = this.getUnit();
        paramList.add(new RdbmsLongColumnParameter(UNIT, idx++, dayTime));
        RdbmsColumnParameter[] list = new RdbmsColumnParameter[paramList.size()];
        paramList.toArray(list);
        return list;
    }

    protected String makeChkSql(String sql) {
        StringBuffer sb = new StringBuffer(sql);
        sb.append(" WHERE ");
        sb.append(COLLECTION_NAME).append(" = ? ");
        sb.append("AND ");
        sb.append(PROFILE_NAME).append(" = ? ");
        sb.append("AND ");
        sb.append(KEYWORD).append(" = ? ");
        sb.append("AND ");
        sb.append(UNIT).append(" = ? ");
        return sb.toString();
    }

    private RdbmsColumnParameter[] getSelectParameter(String collection, String profile, String keyword, Date from, Date to) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        int idx = 1;
        if (!StringUtil.isEmpty((String)collection)) {
            paramList.add(new RdbmsStringColumnParameter(COLLECTION_NAME, idx++, collection));
        }
        if (!StringUtil.isEmpty((String)profile)) {
            paramList.add(new RdbmsStringColumnParameter(PROFILE_NAME, idx++, profile));
        }
        if (keyword != null) {
            paramList.add(new RdbmsStringColumnParameter(KEYWORD, idx++, keyword));
        }
        if (from != null) {
            paramList.add(new RdbmsLongColumnParameter(UNIT, idx++, from.getTime()));
        }
        if (to != null) {
            paramList.add(new RdbmsLongColumnParameter(UNIT, idx++, to.getTime()));
        }
        if (idx <= 1) {
            return null;
        }
        RdbmsColumnParameter[] list = new RdbmsColumnParameter[paramList.size()];
        paramList.toArray(list);
        return list;
    }

    protected abstract long getUnit();

    protected abstract String getTablename();

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }
}

