/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.feedback.FeedbackEntity;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class FeedbackDB {
    static final long DAY = 86400000L;
    static final long HOUR = 3600000L;
    static final String EMPTY = "*";
    protected static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    protected static final String PREFIX = properties.getPrefix();
    static final String TABLE = String.valueOf(PREFIX) + "_FEEDBACK";
    static final String SQL_INSERT = " INSERT INTO " + TABLE + " (METHOD, COLLECTION_ID, PROFILE_ID, KEYWORD, STR_PARAM1, STR_PARAM2, STR_PARAM3, NUM_PARAM1, NUM_PARAM2, NUM_PARAM3, REG_DATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final String SQL_DELETE_OLD = " DELETE FROM " + TABLE + " WHERE REG_DATE < ?";
    static final String SQL_SELECT_PROFILE = " SELECT METHOD, COLLECTION_ID, PROFILE_ID, KEYWORD, STR_PARAM1, STR_PARAM2, STR_PARAM3, NUM_PARAM1, NUM_PARAM2, NUM_PARAM3, REG_DATE FROM " + TABLE + " WHERE METHOD=? AND COLLECTION_ID=? AND PROFILE_ID=? AND REG_DATE BETWEEN ? AND ? ORDER BY REG_DATE ASC";
    static final String SQL_SELECT_COLLECTION = " SELECT METHOD, COLLECTION_ID, PROFILE_ID, KEYWORD, STR_PARAM1, STR_PARAM2, STR_PARAM3, NUM_PARAM1, NUM_PARAM2, NUM_PARAM3, REG_DATE FROM " + TABLE + " WHERE METHOD=? AND COLLECTION_ID=? AND REG_DATE BETWEEN ? AND ? ORDER BY REG_DATE ASC";
    static final String SQL_SELECT_ALL = " SELECT METHOD, COLLECTION_ID, PROFILE_ID, KEYWORD, STR_PARAM1, STR_PARAM2, STR_PARAM3, NUM_PARAM1, NUM_PARAM2, NUM_PARAM3, REG_DATE FROM " + TABLE + " WHERE METHOD=? AND REG_DATE BETWEEN ? AND ? ORDER BY REG_DATE ASC";
    static final String SQL_SELECT_KEYWORD = " SELECT METHOD, COLLECTION_ID, PROFILE_ID, KEYWORD, STR_PARAM1, STR_PARAM2, STR_PARAM3, NUM_PARAM1, NUM_PARAM2, NUM_PARAM3, REG_DATE FROM " + TABLE + " WHERE METHOD=? AND COLLECTION_ID=? AND PROFILE_ID=? AND KEYWORD=? AND REG_DATE BETWEEN ? AND ? ORDER BY REG_DATE ASC";

    public static FeedbackEntity[] getListProfile(Connection conn, String methodName, String collectionID, String profileID, long startDate, long endDate) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = EMPTY;
        }
        RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("METHOD", 1, methodName), new RdbmsStringColumnParameter("COLLECTION_ID", 2, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 3, profileID), new RdbmsDateColumnParameter("REG_DATE", 4, new Timestamp(startDate)), new RdbmsDateColumnParameter("REG_DATE", 5, new Timestamp(endDate))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_PROFILE, parameters);
        List results = rdbmsSupporter.fetchItems(conn, query);
        return FeedbackEntity.create(results);
    }

    public static FeedbackEntity[] getListCollection(Connection conn, String methodName, String collectionID, long startDate, long endDate) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("METHOD", 1, methodName), new RdbmsStringColumnParameter("COLLECTION_ID", 2, collectionID), new RdbmsDateColumnParameter("REG_DATE", 3, new Timestamp(startDate)), new RdbmsDateColumnParameter("REG_DATE", 4, new Timestamp(endDate))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COLLECTION, parameters);
        List results = rdbmsSupporter.fetchItems(conn, query);
        return FeedbackEntity.create(results);
    }

    public static FeedbackEntity[] getList(Connection conn, String methodName, long startDate, long endDate) throws SQLException {
        RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("METHOD", 1, methodName), new RdbmsDateColumnParameter("REG_DATE", 2, new Timestamp(startDate)), new RdbmsDateColumnParameter("REG_DATE", 3, new Timestamp(endDate))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_ALL, parameters);
        List results = rdbmsSupporter.fetchItems(conn, query);
        return FeedbackEntity.create(results);
    }

    public static FeedbackEntity[] getListByKeyword(Connection conn, String methodName, String collectionID, String profileID, String keyword, long startDate, long endDate) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = EMPTY;
        }
        RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("METHOD", 1, methodName), new RdbmsStringColumnParameter("COLLECTION_ID", 2, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 3, profileID), new RdbmsStringColumnParameter("KEYWORD", 4, keyword), new RdbmsDateColumnParameter("REG_DATE", 5, new Timestamp(startDate)), new RdbmsDateColumnParameter("REG_DATE", 6, new Timestamp(endDate))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_KEYWORD, parameters);
        List results = rdbmsSupporter.fetchItems(conn, query);
        return FeedbackEntity.create(results);
    }

    public static void put(Connection conn, String methodName, String collectionID, String profileID, String keyword, String[] strParams, int[] intParams) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = EMPTY;
        }
        boolean success = false;
        long currentTime = System.currentTimeMillis() - 43200000L;
        currentTime = DateUtil.getDayStart((long)currentTime);
        String[] stringParams = new String[3];
        if (strParams != null) {
            int i = 0;
            while (i < strParams.length && i < 3) {
                stringParams[i] = strParams[i];
                ++i;
            }
        }
        int[] integerParams = new int[3];
        if (intParams != null) {
            int i = 0;
            while (i < intParams.length && i < 3) {
                integerParams[i] = intParams[i];
                ++i;
            }
        }
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("METHOD", 1, methodName), new RdbmsStringColumnParameter("COLLECTION_ID", 2, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 3, profileID), new RdbmsStringColumnParameter("KEYWORD", 4, keyword), new RdbmsStringColumnParameter("STR_PARAM1", 5, stringParams[0]), new RdbmsStringColumnParameter("STR_PARAM2", 6, stringParams[1]), new RdbmsStringColumnParameter("STR_PARAM3", 7, stringParams[2]), new RdbmsIntColumnParameter("NUM_PARAM1", 8, integerParams[0]), new RdbmsIntColumnParameter("NUM_PARAM2", 9, integerParams[1]), new RdbmsIntColumnParameter("NUM_PARAM3", 10, integerParams[2]), new RdbmsDateColumnParameter("REG_DATE", 11, new Timestamp(currentTime))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteOld(Connection conn, int days) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                long currentTime = System.currentTimeMillis();
                long startOfDay = currentTime - currentTime % 86400000L;
                long bounds = startOfDay - 86400000L * (long)days;
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsDateColumnParameter("REG_DATE", 1, new Timestamp(bounds))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_OLD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }
}

