/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.handler.feedback.FeedbackDB;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;

public class FeedbackDataInsert
extends FeedbackDB {
    public static void insert(Connection conn, long date, String collectionID, String profileID, int queryCount) throws SQLException {
        FeedbackDataInsert.insertQueryCount(conn, date, collectionID, profileID, queryCount);
        FeedbackDataInsert.insertNavClick(conn, date, collectionID, profileID, queryCount);
        FeedbackDataInsert.insertDocClick(conn, date, collectionID, profileID, queryCount);
    }

    public static void insertQueryCount(Connection conn, long date, String collectionID, String profileID, int queryCount) throws SQLException {
        int[] intParams = new int[]{queryCount};
        System.out.println("queryCount = " + queryCount);
        FeedbackDataInsert.put(date, conn, "SEARCH_QUERY", collectionID, profileID, null, null, intParams);
    }

    public static void insertNavClick(Connection conn, long date, String collectionID, String profileID, int queryCount) throws SQLException {
        Random rand = new Random();
        int randVal = rand.nextInt(Math.abs((int)date % 37) + 17);
        randVal = Math.abs(randVal % 200) + 52;
        int navClick = queryCount * randVal / 1000;
        int[] intParams = new int[]{navClick};
        System.out.println("navClick = " + navClick);
        FeedbackDataInsert.put(date, conn, "CLICK_NAVIGATION", collectionID, profileID, null, null, intParams);
    }

    public static void insertDocClick(Connection conn, long date, String collectionID, String profileID, int queryCount) throws SQLException {
        Random rand = new Random();
        int randVal = rand.nextInt(Math.abs((int)date % 37) + 17);
        randVal = Math.abs(randVal % 100) + 850;
        int[] clicks = new int[10];
        int seed = queryCount / 55;
        System.out.print("clicks = ");
        int clickSum = 0;
        int i = 0;
        while (i < 10) {
            randVal = rand.nextInt(Math.abs((int)date % 37) + 17);
            randVal = Math.abs(randVal % 100) + 900;
            clicks[i] = seed * (10 - i) * randVal / 1000;
            clickSum += clicks[i];
            System.out.print("[" + clicks[i] + "]");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 10) {
            int[] intParams = new int[]{i, clicks[i]};
            FeedbackDataInsert.put(date, conn, "CLICK_DOCUMENT", collectionID, profileID, null, null, intParams);
            ++i;
        }
        if (queryCount < clickSum) {
            System.out.println("###################" + queryCount + " " + clickSum);
        }
    }

    public static void put(long date, Connection conn, String methodName, String collectionID, String profileID, String keyword, String[] strParams, int[] intParams) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        long currentTime = DateUtil.getDayStart((long)date);
        String[] stringParams = new String[3];
        if (strParams != null) {
            int i = 0;
            while (i < strParams.length && i < 3) {
                stringParams[i] = strParams[i];
                ++i;
            }
        }
        int[] integerParams = new int[3];
        if (intParams != null) {
            int i = 0;
            while (i < intParams.length && i < 3) {
                integerParams[i] = intParams[i];
                ++i;
            }
        }
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("METHOD", 1, methodName), new RdbmsStringColumnParameter("COLLECTION_ID", 2, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 3, profileID), new RdbmsStringColumnParameter("KEYWORD", 4, keyword), new RdbmsStringColumnParameter("STR_PARAM1", 5, stringParams[0]), new RdbmsStringColumnParameter("STR_PARAM2", 6, stringParams[1]), new RdbmsStringColumnParameter("STR_PARAM3", 7, stringParams[2]), new RdbmsIntColumnParameter("NUM_PARAM1", 8, integerParams[0]), new RdbmsIntColumnParameter("NUM_PARAM2", 9, integerParams[1]), new RdbmsIntColumnParameter("NUM_PARAM3", 10, integerParams[2]), new RdbmsDateColumnParameter("REG_DATE", 11, new Timestamp(currentTime))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void main(String[] args) throws SQLException {
        int iteration = 30;
        Connection conn = ConnectionFactory.getConnection();
        long date = DateUtil.getDayStart((long)System.currentTimeMillis()) - 2592000000L;
        String collectionID = "DQ_TEST_BLOG";
        String profileID = "";
        int baseQueryCount = 13000;
        int i = 0;
        while (i < iteration) {
            System.out.println("ITERATION : " + i + " ================================");
            System.out.println(new Date(date += 86400000L));
            Random rand = new Random();
            int randVal = Math.abs(rand.nextInt((int)(date % 7177L)));
            int queryCount = baseQueryCount + randVal;
            FeedbackDataInsert.insert(conn, date, collectionID, profileID, queryCount);
            ++i;
        }
        conn.close();
    }
}

