/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback;

import com.diquest.commons.db.SqlUtil;
import com.diquest.ir.common.database.SqlAppendUtil;
import com.diquest.ir.common.database.entity.feedback.FeedbackKeywordEntity;
import com.diquest.ir.common.database.handler.feedback.AbstractFeedbackDB;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FeedbackKeywordDB
extends AbstractFeedbackDB {
    private static final String TABLENAME = String.valueOf(PREFIX) + "_FEEDBACK_KEYWORD";
    private static final String KEYWORD = "KEYWORD";
    private static final String REG_DATE = "REG_DATE";
    private static final String APPLY = "APPLY";
    private static final String KEYWORD_CNT = "KEYWORD_CNT";
    private static final String[] ALL_COLUMNS = new String[]{"KEYWORD", "REG_DATE", "APPLY"};
    private static final String[] COUNT = new String[]{"COUNT(KEYWORD) as KEYWORD_CNT"};
    private static final String SQL_INSERT = SqlUtil.generateInsertSql((String)TABLENAME, (String[])ALL_COLUMNS);
    private static final String SQL_SELECT_ALL = String.valueOf(SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS)) + " ORDER BY " + "REG_DATE" + " ASC";
    private static final String SQL_SELECT_ORDER_KEYWORD = String.valueOf(SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS)) + " ORDER BY " + "KEYWORD" + " ASC";
    private static final String SQL_SEACH_KEYWORD = String.valueOf(SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS)) + " WHERE " + "KEYWORD" + " LIKE ? " + " ORDER BY ";
    private static final String SQL_SELECT_SINGLE_KEYWORD = String.valueOf(SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS)) + " WHERE " + "KEYWORD" + " = ? ";
    private static final String SQL_COUNT_ALL_KEYWORD = SqlUtil.generateSelectSql((String)TABLENAME, (String[])COUNT);
    private static final String SQL_DELETE = "DELETE FROM " + TABLENAME;
    private static final String SQL_DELETE_SINGLE_KEYWORD = String.valueOf(SQL_DELETE) + " WHERE " + "KEYWORD" + " = ?";
    private static final String SQL_UPDATE_APPLY = SqlUtil.generateUpdateSql((String)TABLENAME, (String[])new String[]{"APPLY"}, (String[])new String[0]);

    public static int excuteInsert(Connection conn, String keyword) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params = FeedbackKeywordDB.getSaveColumnParameter(keyword);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, params);
        return supporter.executeUpdate(conn, query);
    }

    private static RdbmsColumnParameter[] getSaveColumnParameter(String keyword) {
        int idx = 1;
        RdbmsColumnParameter[] paramList = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(KEYWORD, idx++, keyword), new RdbmsDateColumnParameter(REG_DATE, idx++, FeedbackKeywordDB.getRegDate()), new RdbmsStringColumnParameter(APPLY, idx++, '0')};
        return paramList;
    }

    public static FeedbackKeywordEntity[] excuteSelect(Connection conn) throws SQLException {
        return FeedbackKeywordDB.excuteSelectSql(conn, SQL_SELECT_ALL);
    }

    public static FeedbackKeywordEntity[] excuteSelectOrderKeyword(Connection conn) throws SQLException {
        return FeedbackKeywordDB.excuteSelectSql(conn, SQL_SELECT_ORDER_KEYWORD);
    }

    private static FeedbackKeywordEntity[] excuteSelectSql(Connection conn, String sql) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, null);
        List list = supporter.fetchItems(conn, query);
        return FeedbackKeywordEntity.create(list);
    }

    public static FeedbackKeywordEntity[] excuteSearchKeyword(Connection conn, String keyword, String order) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer sb = new StringBuffer(SQL_SEACH_KEYWORD);
        if (order.equals("keyword")) {
            sb.append(KEYWORD).append(" ASC");
        } else if (order.equals("regDate")) {
            sb.append(REG_DATE).append(" ASC");
        }
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(KEYWORD, 1, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sb.toString(), parameters);
        List list = supporter.fetchItems(conn, query);
        return FeedbackKeywordEntity.create(list);
    }

    public static int getTotalKeywordCount(Connection conn) throws SQLException {
        return FeedbackKeywordDB.getCount(conn, SQL_COUNT_ALL_KEYWORD);
    }

    public static FeedbackKeywordEntity excuteSelectSingleKeyword(Connection conn, String keyword) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(KEYWORD, 1, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_SINGLE_KEYWORD, parameters);
        List list = supporter.fetchItems(conn, query);
        if (list.size() > 0) {
            return FeedbackKeywordEntity.create((RdbmsColumnValue[])list.get(0));
        }
        return null;
    }

    public static boolean isDuplicated(Connection conn, String keyword) throws SQLException {
        FeedbackKeywordEntity entity = FeedbackKeywordDB.excuteSelectSingleKeyword(conn, keyword);
        return entity != null;
    }

    public static int excuteDeleteSingleKeyword(Connection conn, String keyword) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] params = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(KEYWORD, index++, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_SINGLE_KEYWORD, params);
        return supporter.executeUpdate(conn, query);
    }

    public static int excuteDeleteSeveralKeyword(Connection conn, String[] keywords) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        int size = keywords.length;
        String sql = FeedbackKeywordDB.getDeleteSeveralKeywordSql(size);
        RdbmsColumnParameter[] params = new RdbmsColumnParameter[size];
        int i = 0;
        while (i < size) {
            params[i] = new RdbmsStringColumnParameter(KEYWORD, index++, keywords[i]);
            ++i;
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, params);
        return supporter.executeUpdate(conn, query);
    }

    private static String getDeleteSeveralKeywordSql(int size) {
        StringBuffer sb = new StringBuffer(SQL_DELETE);
        SqlAppendUtil.appendOnlyInWhereCond(sb, KEYWORD, size);
        return sb.toString();
    }

    public static int excuteUpdateApply(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] params = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(APPLY, index++, '1')};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, params);
        return supporter.executeUpdate(conn, query);
    }
}

