/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback;

import com.diquest.commons.db.SqlUtil;
import com.diquest.ir.common.database.SqlAppendUtil;
import com.diquest.ir.common.database.entity.feedback.FeedbackURLEntity;
import com.diquest.ir.common.database.handler.feedback.AbstractFeedbackDB;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FeedbackURLDB
extends AbstractFeedbackDB {
    private static final String TABLENAME = String.valueOf(PREFIX) + "_FEEDBACK_URL";
    private static final String URL = "URL";
    private static final String REG_DATE = "REG_DATE";
    private static final String URL_CNT = "URL_CNT";
    private static final String[] ALL_COLUMNS = new String[]{"URL", "REG_DATE"};
    private static final String[] COUNT = new String[]{"COUNT(URL) as URL_CNT"};
    private static final String SQL_INSERT = SqlUtil.generateInsertSql((String)TABLENAME, (String[])ALL_COLUMNS);
    private static final String SQL_SELECT_ALL = String.valueOf(SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS)) + " ORDER BY " + "REG_DATE" + " ASC";
    private static final String SQL_SELECT_URL = String.valueOf(SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS)) + " WHERE " + "URL" + " = ? ";
    private static final String SQL_COUNT_ALL_URL = SqlUtil.generateSelectSql((String)TABLENAME, (String[])COUNT);
    private static final String SQL_DELETE = "DELETE FROM " + TABLENAME;
    private static final String SQL_DELETE_URL = String.valueOf(SQL_DELETE) + " WHERE " + "URL" + " = ?";

    public static int excuteInsert(Connection conn, String url) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] params = FeedbackURLDB.getSaveColumnParameter(url);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, params);
        return supporter.executeUpdate(conn, query);
    }

    private static RdbmsColumnParameter[] getSaveColumnParameter(String url) {
        int idx = 1;
        RdbmsColumnParameter[] paramList = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(URL, idx++, url), new RdbmsDateColumnParameter(REG_DATE, idx++, FeedbackURLDB.getRegDate())};
        return paramList;
    }

    public static FeedbackURLEntity[] excuteSelect(Connection conn) throws SQLException {
        return FeedbackURLDB.excuteSelectSql(conn, SQL_SELECT_ALL);
    }

    private static FeedbackURLEntity[] excuteSelectSql(Connection conn, String sql) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, null);
        List list = supporter.fetchItems(conn, query);
        return FeedbackURLEntity.create(list);
    }

    public static int getTotalURLCount(Connection conn) throws SQLException {
        return FeedbackURLDB.getCount(conn, SQL_COUNT_ALL_URL);
    }

    public static FeedbackURLEntity excuteSelectURL(Connection conn, String url) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(URL, 1, url)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_URL, parameters);
        List list = supporter.fetchItems(conn, query);
        if (list.size() > 0) {
            return FeedbackURLEntity.create((RdbmsColumnValue[])list.get(0));
        }
        return null;
    }

    public static boolean isDuplicated(Connection conn, String url) throws SQLException {
        FeedbackURLEntity entity = FeedbackURLDB.excuteSelectURL(conn, url);
        return entity != null;
    }

    public static int excuteDeleteSingleURL(Connection conn, String url) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] params = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(URL, index++, url)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_URL, params);
        return supporter.executeUpdate(conn, query);
    }

    public static int excuteDeleteSeveralURLs(Connection conn, String[] urls) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        int size = urls.length;
        String sql = FeedbackURLDB.getDeleteSeveralURLSql(size);
        RdbmsColumnParameter[] params = new RdbmsColumnParameter[size];
        int i = 0;
        while (i < size) {
            params[i] = new RdbmsStringColumnParameter(URL, index++, urls[i]);
            ++i;
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, params);
        return supporter.executeUpdate(conn, query);
    }

    private static String getDeleteSeveralURLSql(int size) {
        StringBuffer sb = new StringBuffer(SQL_DELETE);
        SqlAppendUtil.appendOnlyInWhereCond(sb, URL, size);
        return sb.toString();
    }
}

