/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback;

import com.diquest.commons.db.SqlUtil;
import com.diquest.ir.common.database.entity.feedback.FeedbackStatisticEntity;
import com.diquest.ir.common.database.handler.feedback.AbstractFeedbackStatisticsDB;
import com.diquest.ir.util.common.DateUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public class FeedbackWeeklyStatisticsDB
extends AbstractFeedbackStatisticsDB {
    private static final String TABLENAME = String.valueOf(PREFIX) + "_FEEDBACK_STATISTICS_WEEK";
    private static final String SQL_INSERT_ALL = SqlUtil.generateInsertSql((String)TABLENAME, (String[])ALL_COLUMNS);
    private static final String SQL_SELECT_ALL = SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS);
    private static final String SQL_SUM_FUNCTION_ALL = SqlUtil.generateSelectSql((String)TABLENAME, (String[])SUM_FUNCTIONS_COLUMNS);
    private static final String SQL_CHK_UPDATE = SqlUtil.generateSelectSql((String)TABLENAME, (String[])ALL_COLUMNS);
    private static final String SQL_UPDATE_ALL = SqlUtil.generateUpdateSql((String)TABLENAME, (String[])ID_COLUMNS, (String[])new String[]{"COLLECTION_NAME", "PROFILE_NAME", "KEYWORD", "UNIT"});
    private static final String SQL_DELETE_BEFORE_DATE = "DELETE FROM " + TABLENAME + " WHERE " + "UNIT" + "<" + "?";

    public int excuteWholeFeedbackSave(Connection conn, String collectionName, String profileName, int[] functionCnts) throws SQLException {
        return this.excuteUpdateOrSave(conn, SQL_CHK_UPDATE, SQL_INSERT_ALL, SQL_UPDATE_ALL, collectionName, profileName, "DQ_KEYWORD_DEFAULT", functionCnts);
    }

    public int excuteKeywordFeedbackSave(Connection conn, String collectionName, String profileName, String keyword, int[] functionCnts) throws SQLException {
        return this.excuteUpdateOrSave(conn, SQL_CHK_UPDATE, SQL_INSERT_ALL, SQL_UPDATE_ALL, collectionName, profileName, keyword, functionCnts);
    }

    public FeedbackStatisticEntity[] excuteSelectAll(Connection conn) throws SQLException {
        return this.excuteSelectAll(conn, SQL_SELECT_ALL);
    }

    public FeedbackStatisticEntity[] excuteSelectConditions(Connection conn, String collectionName, String profileName, String keyword) throws SQLException {
        String sql = SQL_SELECT_ALL;
        if (collectionName != null || profileName != null || keyword != null) {
            sql = this.makeSelectWhereSql(sql, collectionName, profileName, keyword, null);
        }
        return this.excuteSelect(conn, sql, collectionName, profileName, keyword, null);
    }

    public FeedbackStatisticEntity[] excuteSelectConditionsAfterDate(Connection conn, String collectionName, String profileName, String keyword, int range, boolean isUnitGroup) throws SQLException {
        String sql = isUnitGroup ? SQL_SUM_FUNCTION_ALL : SQL_SELECT_ALL;
        Date before = DateUtil.getStartBeforeWeek((Date)DateUtil.getStartCurrentWeek(), (int)range);
        sql = this.makeSelectWhereSql(sql, collectionName, profileName, keyword, before, null, isUnitGroup);
        return this.excuteSelect(conn, sql, collectionName, profileName, keyword, before);
    }

    public FeedbackStatisticEntity[] excuteSelectConditionsBetweenDate(Connection conn, String collectionName, String profileName, String keyword, Date from, Date to) throws SQLException {
        return this.excuteSelectConditionsBetweenDate(conn, collectionName, profileName, keyword, from, to, true);
    }

    public FeedbackStatisticEntity[] excuteSelectConditionsBetweenDate(Connection conn, String collectionName, String profileName, String keyword, Date from, Date to, boolean isUnitGroup) throws SQLException {
        String sql = isUnitGroup ? SQL_SUM_FUNCTION_ALL : SQL_SELECT_ALL;
        sql = this.makeSelectWhereSql(sql, collectionName, profileName, keyword, from, to, isUnitGroup);
        return this.excuteSelect(conn, sql, collectionName, profileName, keyword, from, to);
    }

    protected String getTablename() {
        return TABLENAME;
    }

    protected long getUnit() {
        return DateUtil.getWeekStart((long)System.currentTimeMillis());
    }

    public int excuteDeleteFromTodayBeforeDate(Connection conn, int month) throws SQLException {
        return this.excuteDeleteFromTodayBeforeDate(conn, SQL_DELETE_BEFORE_DATE, month);
    }
}

