/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback.impl;

import com.diquest.ir.common.database.entity.feedback.FeedbackEntity;
import com.diquest.ir.common.database.entity.feedback.impl.ClickDocumentEntity;
import com.diquest.ir.common.database.handler.feedback.FeedbackDB;
import com.diquest.ir.util.common.DateUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ClickDocumentFeedbackDB
extends FeedbackDB {
    private static final String methodName = "CLICK_DOCUMENT";
    private static final int[] emptyCountArray = new int[10];

    private static ClickDocumentEntity[] getEntities(String inCollectionID, String inProfileID, FeedbackEntity[] entities, long startDate, long endDate, boolean mergeDate, boolean mergeCollection, boolean mergeProfile) {
        ArrayList<ClickDocumentEntity> list = new ArrayList<ClickDocumentEntity>();
        long period = mergeDate ? 86400000L : 3600000L;
        long current = DateUtil.getDayStart((long)startDate);
        int timeSize = (int)((endDate - startDate) / period);
        int i = 0;
        while (i < entities.length / 10) {
            FeedbackEntity[] sub = new FeedbackEntity[10];
            System.arraycopy(entities, i * 10, sub, 0, 10);
            ClickDocumentEntity cEntity = new ClickDocumentEntity(sub);
            if (mergeCollection) {
                cEntity.setCollectionID("");
            }
            if (mergeProfile) {
                cEntity.setProfileID("");
            }
            if (list.size() == 0) {
                if (mergeDate) {
                    cEntity.trimDownRegDate();
                }
                long nextTime = cEntity.getRegDate();
                String collectionID = cEntity.getCollectionID();
                String profileID = cEntity.getProfileID();
                while (current < nextTime) {
                    list.add(new ClickDocumentEntity(collectionID, profileID, emptyCountArray, 0, current));
                    current += period;
                }
                list.add(cEntity);
                current += period;
            } else {
                ClickDocumentEntity entity = (ClickDocumentEntity)list.get(list.size() - 1);
                if (mergeDate) {
                    cEntity.trimDownRegDate();
                }
                if (entity.getRegDate() == cEntity.getRegDate()) {
                    entity.merge(cEntity);
                } else {
                    long nextTime = cEntity.getRegDate();
                    String collectionID = cEntity.getCollectionID();
                    String profileID = cEntity.getProfileID();
                    while (current < nextTime) {
                        list.add(new ClickDocumentEntity(collectionID, profileID, emptyCountArray, 0, current));
                        current += period;
                    }
                    list.add(cEntity);
                    current += period;
                }
            }
            ++i;
        }
        int listSize = list.size() > timeSize ? list.size() : timeSize;
        ClickDocumentEntity[] cEntities = new ClickDocumentEntity[listSize];
        int i2 = 0;
        while (i2 < listSize) {
            if (i2 < list.size()) {
                cEntities[i2] = (ClickDocumentEntity)list.get(i2);
            } else {
                cEntities[i2] = new ClickDocumentEntity(inCollectionID, inProfileID, emptyCountArray, 0, current);
                current += period;
            }
            ++i2;
        }
        return cEntities;
    }

    public static ClickDocumentEntity[] getListProfile(Connection conn, String collectionID, String profileID, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = ClickDocumentFeedbackDB.getListProfile(conn, methodName, collectionID, profileID, startDate, endDate);
        return ClickDocumentFeedbackDB.getEntities(collectionID, profileID, entities, startDate, endDate, mergeDate, false, false);
    }

    public static ClickDocumentEntity[] getListCollection(Connection conn, String collectionID, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = ClickDocumentFeedbackDB.getListCollection(conn, methodName, collectionID, startDate, endDate);
        return ClickDocumentFeedbackDB.getEntities(collectionID, null, entities, startDate, endDate, mergeDate, false, true);
    }

    public static ClickDocumentEntity[] getList(Connection conn, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = ClickDocumentFeedbackDB.getList(conn, methodName, startDate, endDate);
        return ClickDocumentFeedbackDB.getEntities(null, null, entities, startDate, endDate, mergeDate, false, true);
    }
}

