/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback.impl;

import com.diquest.ir.common.database.entity.feedback.FeedbackEntity;
import com.diquest.ir.common.database.entity.feedback.impl.ClickNavigationEntity;
import com.diquest.ir.common.database.handler.feedback.FeedbackDB;
import com.diquest.ir.util.common.DateUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ClickNavigationFeedbackDB
extends FeedbackDB {
    private static final String methodName = "CLICK_NAVIGATION";

    private static ClickNavigationEntity[] getEntities(String inCollectionID, String inProfileID, FeedbackEntity[] entities, long startDate, long endDate, boolean mergeDate, boolean mergeCollection, boolean mergeProfile) {
        ArrayList<ClickNavigationEntity> list = new ArrayList<ClickNavigationEntity>();
        long period = mergeDate ? 86400000L : 3600000L;
        long current = DateUtil.getDayStart((long)startDate);
        int timeSize = (int)((endDate - startDate) / period);
        int i = 0;
        while (i < entities.length) {
            ClickNavigationEntity nEntity = new ClickNavigationEntity(entities[i]);
            if (mergeCollection) {
                nEntity.setCollectionID("");
            }
            if (mergeProfile) {
                nEntity.setProfileID("");
            }
            if (list.size() == 0) {
                if (mergeDate) {
                    nEntity.trimDownRegDate();
                }
                long nextTime = nEntity.getRegDate();
                String collectionID = nEntity.getCollectionID();
                String profileID = nEntity.getProfileID();
                while (current < nextTime) {
                    list.add(new ClickNavigationEntity(collectionID, profileID, 0, current));
                    current += period;
                }
                list.add(nEntity);
                current += period;
            } else {
                ClickNavigationEntity entity = (ClickNavigationEntity)list.get(list.size() - 1);
                if (mergeDate) {
                    nEntity.trimDownRegDate();
                }
                if (entity.getRegDate() == nEntity.getRegDate()) {
                    entity.merge(nEntity);
                } else {
                    long nextTime = nEntity.getRegDate();
                    String collectionID = nEntity.getCollectionID();
                    String profileID = nEntity.getProfileID();
                    while (current < nextTime) {
                        list.add(new ClickNavigationEntity(collectionID, profileID, 0, current));
                        current += period;
                    }
                    list.add(nEntity);
                    current += period;
                }
            }
            ++i;
        }
        int listSize = list.size() > timeSize ? list.size() : timeSize;
        ClickNavigationEntity[] qEntities = new ClickNavigationEntity[listSize];
        int i2 = 0;
        while (i2 < listSize) {
            if (i2 < list.size()) {
                qEntities[i2] = (ClickNavigationEntity)list.get(i2);
            } else {
                qEntities[i2] = new ClickNavigationEntity(inCollectionID, inProfileID, 0, current);
                current += period;
            }
            ++i2;
        }
        return qEntities;
    }

    public static ClickNavigationEntity[] getListProfile(Connection conn, String collectionID, String profileID, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = ClickNavigationFeedbackDB.getListProfile(conn, methodName, collectionID, profileID, startDate, endDate);
        return ClickNavigationFeedbackDB.getEntities(collectionID, profileID, entities, startDate, endDate, mergeDate, false, false);
    }

    public static ClickNavigationEntity[] getListCollection(Connection conn, String collectionID, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = ClickNavigationFeedbackDB.getListCollection(conn, methodName, collectionID, startDate, endDate);
        return ClickNavigationFeedbackDB.getEntities(collectionID, null, entities, startDate, endDate, mergeDate, false, true);
    }

    public static ClickNavigationEntity[] getList(Connection conn, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = ClickNavigationFeedbackDB.getList(conn, methodName, startDate, endDate);
        return ClickNavigationFeedbackDB.getEntities(null, null, entities, startDate, endDate, mergeDate, true, true);
    }
}

