/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.feedback.impl;

import com.diquest.ir.common.database.entity.feedback.FeedbackEntity;
import com.diquest.ir.common.database.entity.feedback.impl.QueryCountEntity;
import com.diquest.ir.common.database.handler.feedback.FeedbackDB;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class QueryCountFeedbackDB
extends FeedbackDB {
    private static final String methodName = "SEARCH_QUERY";

    private static QueryCountEntity[] getEntities(String inCollectionID, String inProfileID, FeedbackEntity[] entities, long startDate, long endDate, boolean mergeDate, boolean mergeProfile, boolean mergeCollection) {
        ArrayList<QueryCountEntity> list = new ArrayList<QueryCountEntity>();
        long period = mergeDate ? 86400000L : 3600000L;
        long current = DateUtil.getDayStart((long)startDate);
        int timeSize = (int)((endDate - startDate) / period);
        int i = 0;
        while (i < entities.length) {
            QueryCountEntity qEntity = new QueryCountEntity(entities[i]);
            if (mergeCollection) {
                qEntity.setCollectionID("");
            }
            if (mergeProfile) {
                qEntity.setProfileID("");
            }
            if (list.size() == 0) {
                if (mergeDate) {
                    qEntity.trimDownRegDate();
                }
                long nextTime = qEntity.getRegDate();
                String collectionID = qEntity.getCollectionID();
                String profileID = qEntity.getProfileID();
                while (current < nextTime) {
                    list.add(new QueryCountEntity(collectionID, profileID, 0, current));
                    current += period;
                }
                list.add(qEntity);
                current += period;
            } else {
                QueryCountEntity entity = (QueryCountEntity)list.get(list.size() - 1);
                if (mergeDate) {
                    qEntity.trimDownRegDate();
                }
                if (entity.getRegDate() == qEntity.getRegDate()) {
                    entity.merge(qEntity);
                } else {
                    long nextTime = qEntity.getRegDate();
                    String collectionID = qEntity.getCollectionID();
                    String profileID = qEntity.getProfileID();
                    while (current < nextTime) {
                        list.add(new QueryCountEntity(collectionID, profileID, 0, current));
                        current += period;
                    }
                    list.add(qEntity);
                    current += period;
                }
            }
            ++i;
        }
        int listSize = list.size() > timeSize ? list.size() : timeSize;
        QueryCountEntity[] qEntities = new QueryCountEntity[listSize];
        int i2 = 0;
        while (i2 < listSize) {
            if (i2 < list.size()) {
                qEntities[i2] = (QueryCountEntity)list.get(i2);
            } else {
                qEntities[i2] = new QueryCountEntity(inCollectionID, inProfileID, 0, current);
                current += period;
            }
            ++i2;
        }
        return qEntities;
    }

    public static QueryCountEntity[] getListProfile(Connection conn, String collectionID, String profileID, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = QueryCountFeedbackDB.getListProfile(conn, methodName, collectionID, profileID, startDate, endDate);
        return QueryCountFeedbackDB.getEntities(collectionID, profileID, entities, startDate, endDate, mergeDate, false, false);
    }

    public static QueryCountEntity[] getListCollection(Connection conn, String collectionID, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = QueryCountFeedbackDB.getListCollection(conn, methodName, collectionID, startDate, endDate);
        return QueryCountFeedbackDB.getEntities(collectionID, null, entities, startDate, endDate, mergeDate, false, true);
    }

    public static QueryCountEntity[] getList(Connection conn, long startDate, long endDate, boolean mergeDate) throws SQLException {
        FeedbackEntity[] entities = QueryCountFeedbackDB.getList(conn, methodName, startDate, endDate);
        return QueryCountFeedbackDB.getEntities(null, null, entities, startDate, endDate, mergeDate, true, true);
    }

    public static void main(String[] args) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        long currentTime = System.currentTimeMillis() - 259200000L;
        long startDate = DateUtil.getDayStart((long)currentTime);
        long endDate = startDate + 604800000L;
        FeedbackEntity[] entities = QueryCountFeedbackDB.getListProfile(conn, methodName, "test2", null, startDate, endDate);
        System.out.println(entities.length);
        conn.close();
    }
}

