/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.migrate.document;

import com.diquest.ir.common.database.migrate.document.DocumentReader;
import com.diquest.ir.common.database.migrate.document.DocumentSchema;
import com.diquest.ir.common.database.migrate.document.DocumentSyntax;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;

public class DocumentDBExporter {
    DocumentSyntax syntax;
    String sql = null;
    private final DocumentReader reader;
    private final String targetTable;
    private final RdbmsProperties dbInfo;

    public DocumentDBExporter(String documentUri, String databaseUri, String targetTable, DocumentSyntax syntax) throws IOException {
        this.targetTable = targetTable;
        this.syntax = syntax;
        this.reader = new DocumentReader(syntax, new File(documentUri));
        Properties props = new Properties();
        props.load(new FileInputStream(new File(databaseUri)));
        this.dbInfo = RdbmsPropertiesFactory.load();
    }

    public int run() throws IOException, SQLException {
        Map document = null;
        PreparedStatement pstmt = null;
        int count = 0;
        Connection conn = ConnectionFactory.create((RdbmsProperties)this.dbInfo);
        System.out.println(DocumentSchema.generateInsertSql(this.syntax, this.targetTable));
        pstmt = conn.prepareStatement(this.dbInfo.encode(DocumentSchema.generateInsertSql(this.syntax, this.targetTable)));
        try {
            try {
                while ((document = this.reader.read()) != null) {
                    String[] fields = this.syntax.keySet();
                    int i = 0;
                    while (i < fields.length) {
                        String type = this.syntax.getType(fields[i]);
                        String value = (String)document.get(fields[i]);
                        int colIdx = i + 1;
                        if (type.toUpperCase().indexOf("NUMBER") > -1 || type.toUpperCase().indexOf("INT") > -1) {
                            pstmt.setInt(colIdx, Integer.parseInt(value));
                        } else if (type.toUpperCase().indexOf("VARCHAR") > -1) {
                            String tempVal = StringUtil.cut((String)value, (int)512);
                            pstmt.setString(colIdx, this.dbInfo.encode(tempVal));
                        } else if (type.toUpperCase().indexOf("TIMESTAMP") > -1) {
                            pstmt.setTimestamp(colIdx, new Timestamp(DateUtil.getDate((String)value).getTime()));
                        } else if (type.toUpperCase().indexOf("DATE") > -1) {
                            pstmt.setTimestamp(colIdx, new Timestamp(DateUtil.getDate((String)value).getTime()));
                        }
                        ++i;
                    }
                    pstmt.addBatch();
                    if (++count % 10000 != 0 || count == 0) continue;
                    pstmt.executeBatch();
                    System.out.println(String.valueOf(count) + " documents are inserted.");
                }
                pstmt.executeBatch();
                System.out.println(String.valueOf(count) + " documents are inserted.");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return count;
    }
}

