/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.migrate.document;

import com.diquest.ir.common.database.migrate.document.DocumentSyntax;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class DocumentReader {
    private final DocumentSyntax syntax;
    private final BufferedReader buff;
    Map docmap = new HashMap();
    private static final String DOC_OPEN = "(DQ_DOC";
    private static final String DOC_CLOSE = ")DQ_DOC";
    StringBuffer sb = new StringBuffer();

    public DocumentReader(DocumentSyntax syntax, File irt) throws FileNotFoundException {
        this.syntax = syntax;
        this.buff = new BufferedReader(new FileReader(irt));
    }

    public Map read() throws IOException {
        String document = this.readDocument();
        if (document == null) {
            return null;
        }
        String[] tags = this.syntax.keySet();
        this.docmap.clear();
        int i = 0;
        while (i < tags.length) {
            this.docmap.put(tags[i], this.readField(document, tags[i]));
            ++i;
        }
        return this.docmap;
    }

    public String readDocument() throws IOException {
        StringBuffer sb = new StringBuffer();
        int start = -1;
        int end = -1;
        String line = null;
        while ((line = this.buff.readLine()) != null) {
            sb.append(line).append('\n');
            if (line.indexOf(DOC_OPEN) == 0) {
                start = sb.indexOf(DOC_OPEN);
            }
            if (line.indexOf(DOC_CLOSE) == 0) {
                end = sb.indexOf(DOC_CLOSE);
            }
            if (end > 0) break;
        }
        if (start > end || start == -1 || end == -1) {
            return null;
        }
        return sb.toString();
    }

    public String readField(String document, String field) throws IOException {
        StringReader r = new StringReader(document);
        BufferedReader br = new BufferedReader(r);
        String fieldOpen = "(" + field;
        String fieldClose = ")" + field;
        String line = null;
        int start = -1;
        int end = -1;
        while ((line = br.readLine()) != null) {
            this.sb.append(line).append('\n');
            if (line.indexOf(fieldOpen) == 0) {
                start = this.sb.lastIndexOf(fieldOpen);
            }
            if (line.indexOf(fieldClose) == 0) {
                end = this.sb.lastIndexOf(fieldClose);
            }
            if (end > 0) break;
        }
        this.sb.delete(0, this.sb.length());
        return document.substring(start + field.length() + 1, end).trim();
    }
}

