/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.migrate.document;

import com.diquest.ir.common.database.migrate.document.DocumentSyntax;
import com.diquest.ir.util.common.StringUtil;

public class DocumentSchema {
    static final String header = "CREATE TABLE ";

    public static String generateCreateSql(DocumentSyntax irtSyntax, String tableName) {
        String ddl = header + tableName + " (\r\n";
        String[] idSet = irtSyntax.keySet();
        int i = 0;
        while (i < idSet.length) {
            String id = idSet[i];
            String field = irtSyntax.getField(id);
            String schema = irtSyntax.getType(id);
            ddl = String.valueOf(ddl) + "\t" + field;
            ddl = String.valueOf(ddl) + " " + schema;
            ddl = i < idSet.length - 1 ? String.valueOf(ddl) + ",\r\n" : String.valueOf(ddl) + "\r\n";
            ++i;
        }
        ddl = String.valueOf(ddl) + ")";
        return ddl;
    }

    public static String generateInsertSql(DocumentSyntax syntax, String targetTable) {
        String sql = "INSERT INTO " + targetTable + " (";
        String[] fields = syntax.fieldSet();
        sql = String.valueOf(sql) + StringUtil.format((String[])fields, (char)',');
        sql = String.valueOf(sql) + ") values (";
        sql = String.valueOf(sql) + StringUtil.format((String[])StringUtil.rolling((String)"?", (int)syntax.size()), (char)',');
        sql = String.valueOf(sql) + ")";
        return sql;
    }
}

