/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.migrate.document;

import com.diquest.ir.common.database.migrate.document.DocumentSchema;
import com.diquest.ir.common.database.migrate.document.DocumentSyntax;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class DocumentSchemaExporter {
    RdbmsProperties dbInfo;
    private final DocumentSyntax syntax;
    private final String tablename;

    public DocumentSchemaExporter(File database, DocumentSyntax syntax, String tableName) throws FileNotFoundException, IOException, SQLException {
        this.syntax = syntax;
        this.tablename = tableName;
        Properties props = new Properties();
        props.load(new FileInputStream(database));
        this.dbInfo = RdbmsPropertiesFactory.load();
    }

    public DocumentSchemaExporter(String database, DocumentSyntax syntax, String tableName) throws FileNotFoundException, IOException, SQLException {
        this(new File(database), syntax, tableName);
    }

    public boolean export() throws SQLException {
        boolean result;
        Connection conn = ConnectionFactory.create((RdbmsProperties)this.dbInfo);
        String sql = DocumentSchema.generateCreateSql(this.syntax, this.tablename);
        sql = this.dbInfo.encode(sql);
        PreparedStatement stmt = conn.prepareStatement(sql);
        System.out.println("DROP TABLE " + this.tablename + ";");
        try {
            result = stmt.execute("DROP TABLE " + this.tablename);
        }
        catch (SQLException e) {
            System.out.println("Table does not exist : " + this.tablename);
        }
        System.out.println(sql);
        result = stmt.execute(sql);
        if (result) {
            System.out.println(String.valueOf(sql) + ";");
            System.out.println("complete");
        } else {
            System.out.println(String.valueOf(sql) + ";");
            System.out.println("status : complete");
        }
        conn.close();
        return result;
    }
}

