/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.modify;

import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class QueryExecuter {
    private final String url;
    private final String user;
    private final String password;

    public QueryExecuter(String url, String user, String password, String jdbc_class) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public boolean execute(String sql) throws SQLException, ClassNotFoundException {
        Connection connection = null;
        boolean result = false;
        try {
            connection = ConnectionFactory.create((RdbmsProperties)new RdbmsProperties(this.url, this.user, this.password, null));
            connection.setAutoCommit(false);
            Statement stmt = connection.createStatement();
            result = stmt.execute(sql);
            connection.commit();
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        String url = args[0];
        String user = args[1];
        String password = args[2];
        String query = args[3];
        String jdbc_class = args[4];
        System.out.println("url \t\t: \t" + url);
        System.out.println("user \t\t: \t" + user);
        System.out.println("password \t: \t" + password);
        System.out.println("query \t\t: \t" + query);
        System.out.println("jdbc class  : \t" + jdbc_class);
        QueryExecuter executer = new QueryExecuter(url, user, password, jdbc_class);
        boolean success = true;
        try {
            executer.execute(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            success = false;
        }
        System.out.println("success \t: \t" + success);
    }
}

