/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.report.cache.Constraint;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractConstraintCache
implements Observer {
    public static final long EXPIRED = Long.MIN_VALUE;
    private final Map cache = new LinkedHashMap(16, 0.75f, true){
        private static final long serialVersionUID = -1108824384941065268L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return AbstractConstraintCache.this.maxSize < this.size();
        }
    };
    private int maxSize;
    private final Map record = new LinkedHashMap(16, 0.75f, true){
        private static final long serialVersionUID = 1836983906422807024L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return AbstractConstraintCache.this.maxSize < this.size();
        }
    };

    public AbstractConstraintCache() {
        this.setMaxSize(32);
    }

    public final synchronized Object get(Constraint c) {
        return this.cache.get(c);
    }

    public final synchronized int getMaxSize() {
        return this.maxSize;
    }

    public final synchronized long getTime(Constraint c) {
        Long recorded = (Long)this.record.get(c);
        return recorded == null ? Long.MIN_VALUE : recorded;
    }

    public final synchronized void put(Constraint c, Object v, long time) {
        this.cache.put(c, v);
        this.record.put(c, new Long(time));
    }

    public final synchronized void remove(Constraint c) {
        this.cache.remove(c);
        this.record.remove(c);
    }

    public final synchronized void setMaxSize(int size) {
        this.maxSize = size;
        Iterator iterator = this.cache.entrySet().iterator();
        Iterator iterator2 = this.record.keySet().iterator();
        while (this.cache.size() > this.maxSize && iterator.hasNext() && iterator2.hasNext()) {
            iterator.remove();
            iterator2.remove();
        }
    }

    public final synchronized void update(Observable o, Object arg) {
        Iterator iterator = this.cache.keySet().iterator();
        Iterator iterator2 = this.record.keySet().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Constraint c = (Constraint)iterator.next();
            iterator2.next();
            if (arg != null && !c.violates((Constraint)arg)) continue;
            iterator.remove();
            iterator2.remove();
        }
    }
}

