/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.report.cache.Constraint;

public class BooleanConstraint
implements Constraint {
    private static final long serialVersionUID = 4959413988021190536L;
    private Boolean value = null;

    public BooleanConstraint() {
        this.value = null;
    }

    public BooleanConstraint(boolean value) {
        this.value = new Boolean(value);
    }

    public void merge(Constraint c) {
        BooleanConstraint ic = (BooleanConstraint)c;
        if (ic.value == null || this.value == null) {
            this.value = null;
        } else if (!ic.value.equals(this.value)) {
            this.value = null;
        }
    }

    public boolean violates(Constraint c) {
        if (c instanceof BooleanConstraint) {
            BooleanConstraint ic = (BooleanConstraint)c;
            if (this.value == null || ic.value == null) {
                return true;
            }
            return this.value.booleanValue() == ic.value.booleanValue();
        }
        return true;
    }
}

