/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.report.cache.Constraint;
import java.util.Date;

public class DateRangeConstraint
implements Constraint {
    private static final long serialVersionUID = 8834940167966452465L;
    private long from;
    private long to;

    public DateRangeConstraint(long from) {
        this(from, from);
    }

    public DateRangeConstraint(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRangeConstraint)) {
            return false;
        }
        DateRangeConstraint other = (DateRangeConstraint)obj;
        if (this.from != other.from) {
            return false;
        }
        return this.to == other.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        return result;
    }

    public void merge(Constraint c) {
        DateRangeConstraint dr = (DateRangeConstraint)c;
        if (this.from - dr.from > 0L) {
            this.from = dr.from;
        }
        if (this.to - dr.to < 0L) {
            this.to = dr.to;
        }
    }

    public String toString() {
        String TAB = ", ";
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append("from=").append(new Date(this.from)).append(", ");
        buf.append("to=").append(new Date(this.to));
        buf.append("]");
        return buf.toString();
    }

    public boolean violates(Constraint c) {
        if (c instanceof DateRangeConstraint) {
            DateRangeConstraint dc = (DateRangeConstraint)c;
            if (this.to - dc.from <= 0L || dc.to - this.from <= 0L) {
                return false;
            }
        }
        return true;
    }
}

