/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.report.cache.Constraint;

public class IntegerConstraint
implements Constraint {
    private static final long serialVersionUID = 3447388668637523045L;
    private Integer value = null;

    public IntegerConstraint() {
        this.value = null;
    }

    public IntegerConstraint(int value) {
        this.value = new Integer(value);
    }

    public void merge(Constraint c) {
        IntegerConstraint ic = (IntegerConstraint)c;
        if (ic.value == null || this.value == null) {
            this.value = null;
        } else if (!ic.value.equals(this.value)) {
            this.value = null;
        }
    }

    public boolean violates(Constraint c) {
        if (c instanceof IntegerConstraint) {
            IntegerConstraint ic = (IntegerConstraint)c;
            if (this.value == null || ic.value == null) {
                return true;
            }
            return this.value.intValue() == ic.value.intValue();
        }
        return true;
    }
}

