/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.report.cache.Constraint;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class MultipleConstraints
implements Constraint {
    private static final long serialVersionUID = 3510202508620947255L;
    final Map constraints = new HashMap();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipleConstraints)) {
            return false;
        }
        MultipleConstraints other = (MultipleConstraints)obj;
        return !(this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        return result;
    }

    public void merge(Constraint c) {
        MultipleConstraints mc = (MultipleConstraints)c;
        Iterator iterator = this.constraints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Constraint target = (Constraint)mc.constraints.get(entry.getKey());
            if (target == null) continue;
            Constraint mine = (Constraint)entry.getValue();
            mine.merge(target);
        }
        HashSet othersOnly = new HashSet(mc.constraints.keySet());
        othersOnly.removeAll(this.constraints.keySet());
        Iterator keyIter = othersOnly.iterator();
        while (keyIter.hasNext()) {
            String othersKey = (String)keyIter.next();
            this.constraints.put(othersKey, mc.constraints.get(othersKey));
        }
    }

    public void put(String name, Constraint constraint) {
        this.constraints.put(name, constraint);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append("constraints=").append(this.constraints);
        buf.append("]");
        return buf.toString();
    }

    public boolean violates(Constraint c) {
        if (!(c instanceof MultipleConstraints)) {
            return false;
        }
        MultipleConstraints cs = (MultipleConstraints)c;
        boolean violates = false;
        Iterator iterator = this.constraints.entrySet().iterator();
        while (!violates && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Constraint target = (Constraint)cs.constraints.get(entry.getKey());
            Constraint mine = (Constraint)entry.getValue();
            violates |= target == null || mine.violates(target);
        }
        return violates;
    }
}

