/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.entity.AbstractKeywordCountQueryLog;
import com.diquest.ir.common.database.report.cache.CollectionConstraint;
import com.diquest.ir.common.database.report.cache.DateRangeConstraint;
import com.diquest.ir.common.database.report.cache.MultipleConstraints;
import com.diquest.ir.common.database.report.cache.ProfileConstraint;

public class PopularQueryLogDbConstraint
extends MultipleConstraints {
    private static final long serialVersionUID = -2395790714062802160L;

    public static PopularQueryLogDbConstraint of(AbstractKeywordCountQueryLog log) {
        return PopularQueryLogDbConstraint.of(log.getCollection(), log.getProfile(), log.getRegistered(), log.getDuration() + log.getRegistered());
    }

    public static PopularQueryLogDbConstraint of(boolean pageable, int limit, int offset, String orderColumn, boolean orderDirection, String keyword, String[] collections, String[][] profiles, long from, long to, int referenceLimit) {
        int i;
        PopularQueryLogDbConstraint cons = new PopularQueryLogDbConstraint();
        if (collections != null && collections.length > 0) {
            CollectionConstraint cc = new CollectionConstraint(collections[0]);
            i = 1;
            while (i < collections.length) {
                cc.merge(collections[i]);
                ++i;
            }
            cons.put("collection", cc);
        }
        if (profiles != null && profiles.length > 0) {
            ProfileConstraint pc = new ProfileConstraint(String.valueOf(profiles[0][1]) + "." + profiles[0][2]);
            i = 1;
            while (i < profiles.length) {
                pc.merge(String.valueOf(profiles[i][1]) + "." + profiles[i][2]);
                ++i;
            }
            cons.put("profile", pc);
        }
        if (from != -1L && to != -1L) {
            cons.put("date", new DateRangeConstraint(from, to));
        }
        return cons;
    }

    public static PopularQueryLogDbConstraint of(String collection, String profile, long from, long to) {
        PopularQueryLogDbConstraint cons = new PopularQueryLogDbConstraint();
        if (collection != null) {
            CollectionConstraint cc = new CollectionConstraint(collection);
            cons.put("collection", cc);
            if (profile != null) {
                ProfileConstraint pc = new ProfileConstraint(String.valueOf(collection) + "." + profile);
                cons.put("profile", pc);
            }
        }
        if (from != -1L && to != -1L) {
            cons.put("date", new DateRangeConstraint(from, to));
        }
        return cons;
    }

    public static PopularQueryLogDbConstraint of(String[] collections, String[][] profiles, long from, long to) {
        int i;
        PopularQueryLogDbConstraint cons = new PopularQueryLogDbConstraint();
        if (collections != null && collections.length > 0) {
            CollectionConstraint cc = new CollectionConstraint(collections[0]);
            i = 1;
            while (i < collections.length) {
                cc.merge(collections[i]);
                ++i;
            }
            cons.put("collection", cc);
        }
        if (profiles != null && profiles.length > 0) {
            ProfileConstraint pc = new ProfileConstraint(String.valueOf(profiles[0][1]) + "." + profiles[0][2]);
            i = 1;
            while (i < profiles.length) {
                pc.merge(String.valueOf(profiles[i][1]) + "." + profiles[i][2]);
                ++i;
            }
            cons.put("profile", pc);
        }
        if (from != -1L && to != -1L) {
            cons.put("date", new DateRangeConstraint(from, to));
        }
        return cons;
    }
}

