/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.report.cache;

import com.diquest.ir.common.database.report.cache.CollectionConstraint;
import com.diquest.ir.common.database.report.cache.DateRangeConstraint;
import com.diquest.ir.common.database.report.cache.MultipleConstraints;
import com.diquest.ir.common.database.report.cache.ProfileConstraint;
import com.diquest.ir.common.database.report.cache.ServerConstraint;

public class StatisticalQueryLogDbConstraint
extends MultipleConstraints {
    private static final long serialVersionUID = 8237217329785156118L;

    public static StatisticalQueryLogDbConstraint of(String[] collections, String[][] profiles, String[] servers, long from, long to) {
        int i;
        StatisticalQueryLogDbConstraint cons = new StatisticalQueryLogDbConstraint();
        if (collections != null && collections.length > 0) {
            CollectionConstraint cc = new CollectionConstraint(collections[0]);
            i = 1;
            while (i < collections.length) {
                cc.merge(collections[i]);
                ++i;
            }
            cons.put("collection", cc);
        }
        if (servers != null && servers.length > 0) {
            ServerConstraint sc = new ServerConstraint(servers[0]);
            i = 1;
            while (i < servers.length) {
                sc.merge(servers[i]);
                ++i;
            }
            cons.put("server", sc);
        }
        if (profiles != null && profiles.length > 0) {
            ProfileConstraint pc = new ProfileConstraint(String.valueOf(profiles[0][0]) + "." + profiles[0][1]);
            i = 1;
            while (i < profiles.length) {
                pc.merge(String.valueOf(profiles[i][0]) + "." + profiles[i][1]);
                ++i;
            }
            cons.put("profile", pc);
        }
        if (from != -1L && to != -1L) {
            cons.put("date", new DateRangeConstraint(from, to));
        }
        return cons;
    }
}

