/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.exception;

import java.io.PrintStream;

public class ContextException
extends Exception {
    private static final long serialVersionUID = 8594588329586131188L;
    private final String service;
    private final String module;

    public ContextException(String service, String module, String message) {
        super(message);
        this.service = service;
        this.module = module;
    }

    public ContextException(String service, String module, String message, Throwable cause) {
        super(message, cause);
        this.service = service;
        this.module = module;
    }

    public String getBusinessMessage() {
        this.getLocalizedMessage();
        return null;
    }

    public String getService() {
        return this.service;
    }

    public String getModule() {
        return this.module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            ContextException c = this;
            while (c != null) {
                s.println("[" + c.service + "] " + c.module + " : " + c.getMessage());
                Throwable cause = c.getCause();
                if (cause == null) break;
                if (cause instanceof ContextException) {
                    c = (ContextException)cause;
                    continue;
                }
                cause.printStackTrace(s);
                break;
            }
        }
        super.printStackTrace(s);
    }
}

