/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.exception;

import com.diquest.ir.common.msg.ProfileKey;

public class IRException
extends Exception {
    public static final byte NONE = 0;
    public static final byte WARN = 1;
    public static final byte ERROR = 2;
    public static final byte FATAL = 3;
    public static final String[] LEVELS;
    private static final long serialVersionUID = 4836378005925358760L;
    private byte level = 0;
    private ProfileKey profileKey;

    static {
        String[] stringArray = new String[4];
        stringArray[1] = "WARN";
        stringArray[2] = "ERROR";
        stringArray[3] = "FATAL";
        LEVELS = stringArray;
    }

    public IRException(String message) {
        super(message);
    }

    public IRException(String message, ProfileKey profileKey) {
        super(message);
        this.profileKey = profileKey;
    }

    public IRException(byte level, String message) {
        super(message);
        this.level = level;
    }

    public IRException(byte level, String message, ProfileKey profileKey) {
        super(message);
        this.level = level;
        this.profileKey = profileKey;
    }

    public IRException(String message, Throwable cause) {
        super(message, cause);
        if (cause instanceof IRException) {
            IRException ncause = (IRException)cause;
            this.level = ncause.level;
            if (this.profileKey == null && ncause.profileKey != null) {
                this.profileKey = ncause.profileKey;
            }
        }
    }

    public IRException(String message, ProfileKey profileKey, Throwable cause) {
        this(message, cause);
        this.profileKey = profileKey;
    }

    public IRException(byte level, String message, Throwable cause) {
        this(message, cause);
        if (this.level < level) {
            this.level = level;
        }
    }

    public IRException(byte level, String message, ProfileKey profileKey, Throwable cause) {
        this(message, cause);
        if (this.level < level) {
            this.level = level;
        }
        this.profileKey = profileKey;
    }

    public IRException(byte level, IRException ce) {
        super(ce);
        if (this.profileKey == null && ce.profileKey != null) {
            this.profileKey = ce.profileKey;
        }
        this.level = level > ce.level ? level : ce.level;
    }

    public IRException(byte level, ProfileKey profileKey, IRException ce) {
        super(ce);
        this.level = level > ce.level ? level : ce.level;
        this.profileKey = profileKey;
    }

    public IRException(IRException ce) {
        this(ce.level, ce);
    }

    public IRException(IRException ce, ProfileKey profileKey) {
        this(ce.level, ce);
        this.profileKey = profileKey;
    }

    public IRException(String message, Throwable cause, ProfileKey profileKey) {
        this(message, cause);
        this.profileKey = profileKey;
    }

    public IRException(String a, String b, String c) {
    }

    public IRException(String a, String b, String c, Throwable e) {
    }

    public Throwable getRootCause() {
        Throwable bcause;
        Throwable rcause = bcause = this.getCause();
        while (rcause != null) {
            rcause = bcause.getCause();
            if (rcause == null) continue;
            bcause = rcause;
        }
        if (bcause == null) {
            return this;
        }
        return bcause;
    }

    public String getLocalMessage() {
        Throwable tr = this;
        String message = null;
        while (tr instanceof IRException) {
            message = tr.getMessage();
            if ((tr = tr.getCause()) != null) continue;
            return message;
        }
        return message;
    }

    private void getBusinessTraceText(Throwable t, StringBuffer buf) {
        IRException tr2;
        if (t.getCause() != null) {
            this.getBusinessTraceText(t.getCause(), buf);
        }
        if (t instanceof IRException) {
            tr2 = (IRException)t;
            buf.append(t.getClass().getName());
            buf.append(": ");
            if (tr2.level != 0) {
                buf.append('[');
                buf.append(LEVELS[tr2.level]);
                buf.append(']');
            }
        } else {
            return;
        }
        buf.append(tr2.getMessage());
        buf.append("\n\tat ");
        buf.append(t.getStackTrace()[0]);
        buf.append('\n');
    }

    public String getBusinessTraceText() {
        StringBuffer buf = new StringBuffer();
        this.getBusinessTraceText(this, buf);
        return buf.toString();
    }

    public String getRawTraceText() {
        Throwable tr = this;
        while (tr instanceof IRException) {
            if ((tr = tr.getCause()) != null) continue;
            return "";
        }
        StackTraceElement[] trace = tr.getStackTrace();
        StringBuffer buf = new StringBuffer();
        buf.append(tr);
        buf.append('\n');
        int i = 0;
        while (i < trace.length) {
            buf.append("\tat ");
            buf.append(trace[i]);
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        buf.append(String.valueOf(s) + ": ");
        if (this.level != 0) {
            buf.append('[');
            buf.append(LEVELS[this.level]);
            buf.append(']');
        }
        if (message != null) {
            buf.append(message);
        }
        if (this.profileKey != null) {
            buf.append((Object)this.profileKey);
        }
        return buf.toString();
    }

    public ProfileKey getProfileKey() {
        return this.profileKey;
    }

    public byte getLevel() {
        return this.level;
    }

    public boolean isWarning() {
        return this.level == 1;
    }
}

