/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.filter.port;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.filter.M2FilterResult;
import com.diquest.ir.common.filter.port.PortProposal;
import com.diquest.ir.util.common.NetworkUtil;
import java.util.Arrays;

public class PortFilter {
    private int PORT_GAP;
    private String[] aIp;
    private int[] aPort;

    public PortFilter(String[] aIp, int[] aPort) throws IRException {
        this(aIp, aPort, 5);
    }

    public PortFilter(String[] aIp, int[] aPort, int gap) throws IRException {
        this.aIp = aIp;
        this.aPort = aPort;
        this.PORT_GAP = gap;
    }

    public M2FilterResult accept(String ip, int port) {
        int i = 0;
        while (i < this.aIp.length) {
            int basePort;
            if (NetworkUtil.isSameAddress((String)ip, (String)this.aIp[i]) && ((basePort = this.aPort[i]) <= port && port < basePort + this.PORT_GAP || basePort < port + this.PORT_GAP && port + this.PORT_GAP <= basePort + this.PORT_GAP)) {
                PortProposal proposal = new PortProposal();
                proposal.setSuitablePorts(this.findSuitablePorts(ip));
                return M2FilterResult.fail("Not Suitable Port Number!", proposal);
            }
            ++i;
        }
        return M2FilterResult.success();
    }

    private int[][] findSuitablePorts(String ip) {
        int[] aTemp = new int[this.aPort.length];
        int portInSameIpCount = 0;
        int i = 0;
        while (i < this.aIp.length) {
            if (NetworkUtil.isSameAddress((String)ip, (String)this.aIp[i])) {
                aTemp[portInSameIpCount] = this.aPort[i];
                ++portInSameIpCount;
            }
            ++i;
        }
        int[] usedPort = new int[portInSameIpCount];
        System.arraycopy(aTemp, 0, usedPort, 0, portInSameIpCount);
        Arrays.sort(usedPort);
        int[][] portRangeTemp = new int[portInSameIpCount + 1][2];
        portRangeTemp[0][0] = 0;
        portRangeTemp[0][1] = usedPort[0] - this.PORT_GAP;
        int index = 1;
        int i2 = 0;
        while (i2 < usedPort.length - 1) {
            int startPort = usedPort[i2] + this.PORT_GAP;
            int endPort = usedPort[i2 + 1] - this.PORT_GAP;
            if (startPort <= endPort) {
                portRangeTemp[index][0] = startPort;
                portRangeTemp[index][1] = endPort;
                ++index;
            }
            ++i2;
        }
        portRangeTemp[index][0] = usedPort[usedPort.length - 1] + this.PORT_GAP;
        portRangeTemp[index][1] = 0;
        int[][] portRange = new int[index + 1][2];
        System.arraycopy(portRangeTemp, 0, portRange, 0, index + 1);
        return portRange;
    }

    public M2FilterResult accept() {
        return null;
    }
}

