/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ThesaurusKey
extends Transmitable {
    private static final byte NULL_FLAG = 0;
    public String collectionID;
    public String profileID;
    public byte thesaurusID;

    public ThesaurusKey(String collectionID, String profileID, byte thesaurusID) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.thesaurusID = thesaurusID;
    }

    public ThesaurusKey() {
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.collectionID != null) {
            hashcode += this.collectionID.hashCode();
        }
        if (this.profileID != null) {
            hashcode += this.profileID.hashCode();
        }
        if (this.thesaurusID != 0) {
            hashcode += new Byte(this.thesaurusID).hashCode();
        }
        return hashcode;
    }

    public static ThesaurusKey getKey(String collectionID) {
        return new ThesaurusKey(collectionID, null, 0);
    }

    public static ThesaurusKey getKey(char[] collectionID) {
        return ThesaurusKey.getKey(new String(collectionID));
    }

    public static ThesaurusKey getKey(String collectionID, String profileID) {
        return new ThesaurusKey(collectionID, profileID, 0);
    }

    public static ThesaurusKey getKey(char[] collectionID, char[] profileID) {
        return ThesaurusKey.getKey(collectionID == null ? null : new String(collectionID), profileID == null ? null : new String(profileID));
    }

    public static ThesaurusKey getKey(char[] collectionID, String profileID) {
        return ThesaurusKey.getKey(collectionID == null ? null : new String(collectionID), profileID);
    }

    public static ThesaurusKey getKey(String collectionID, char[] profileID) {
        return ThesaurusKey.getKey(collectionID, profileID == null ? null : new String(profileID));
    }

    public static ThesaurusKey getKey(String collectionID, String profileID, byte thesaurusID) {
        return new ThesaurusKey(collectionID, profileID, thesaurusID);
    }

    public static ThesaurusKey getKey(char[] collectionID, String profileID, byte thesaurusID) {
        return ThesaurusKey.getKey(collectionID == null ? null : new String(collectionID), profileID, thesaurusID);
    }

    public static ThesaurusKey getKey(String collectionID, char[] profileID, byte thesaurusID) {
        return ThesaurusKey.getKey(collectionID, profileID == null ? null : new String(profileID), thesaurusID);
    }

    public static ThesaurusKey getKey(char[] collectionID, char[] profileID, byte thesaurusID) {
        return ThesaurusKey.getKey(collectionID == null ? null : new String(collectionID), profileID == null ? null : new String(profileID), thesaurusID);
    }

    public boolean equals(Object obj) {
        ThesaurusKey po = (ThesaurusKey)((Object)obj);
        return (po.collectionID == this.collectionID || po.collectionID != null && po.collectionID.equalsIgnoreCase(this.collectionID)) && (po.profileID == this.profileID || po.profileID != null && po.profileID.equalsIgnoreCase(this.profileID)) && po.thesaurusID == this.thesaurusID;
    }

    public String toString() {
        if (this.collectionID == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)this.profileID)) {
            return "[collection:" + this.collectionID + "]";
        }
        if (this.thesaurusID == 0) {
            return "[collection:" + this.collectionID + "][profile:" + this.profileID + "]";
        }
        return "[collection:" + this.collectionID + "][profile:" + this.profileID + "][thesaurus:" + this.thesaurusID + "]";
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.collectionID);
        ByteUtil.writeString((OutputStream)out, (String)this.profileID);
        ByteUtil.writeByte((OutputStream)out, (byte)this.thesaurusID);
    }

    public void deserialize(InputStream in) throws IOException {
        this.collectionID = ByteUtil.readString((InputStream)in);
        this.profileID = ByteUtil.readString((InputStream)in);
        this.thesaurusID = ByteUtil.readByte((InputStream)in);
    }

    public Transmitable getInstance() {
        return new ThesaurusKey();
    }

    public boolean isNull() {
        return this.collectionID == null;
    }
}

