/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.collection;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CollectionInfo
extends Transmitable
implements Serializable {
    private static final long serialVersionUID = -2521552292140292597L;
    private String collectionID;
    private String[] profileIDs;

    public CollectionInfo() {
    }

    public CollectionInfo(String collectionID, String[] profileIDs) {
        this.collectionID = collectionID;
        this.profileIDs = profileIDs;
    }

    public void deserialize(InputStream in) throws IOException {
        this.collectionID = ByteUtil.readString((InputStream)in);
        int profiles = ByteUtil.readInt((InputStream)in);
        this.profileIDs = new String[profiles];
        int i = 0;
        while (i < profiles) {
            this.profileIDs[i] = ByteUtil.readString((InputStream)in);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new CollectionInfo();
    }

    public boolean isNull() {
        return this.collectionID == null;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.collectionID);
        ByteUtil.writeInt((OutputStream)out, (int)this.profileIDs.length);
        int i = 0;
        while (i < this.profileIDs.length) {
            ByteUtil.writeString((OutputStream)out, (String)this.profileIDs[i]);
            ++i;
        }
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String[] getProfileIDs() {
        return this.profileIDs;
    }

    public void setProfileIDs(String[] profileIDs) {
        this.profileIDs = profileIDs;
    }
}

