/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.collection;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.collection.ProfileInfoType;
import com.diquest.ir.common.setting.manager.ProfileSettingManager;
import com.diquest.ir.common.setting.profile.DefaultProfile;
import com.diquest.ir.common.setting.profile.InheritThesaurus;
import com.diquest.ir.common.setting.profile.InheritThesaurusType;
import com.diquest.ir.common.setting.profile.ObjectFactory;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.TraverseException;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;

public class DefaultProfileInfo
extends ProfileInfoType {
    private static final int THESAURUS_EQUIV_SYNONYM = 0;
    private static final int SYS_THESAURUS_EQUIV_SYNONYM = 1;
    private static final int THESAURUS_QUASI_SYNONYM = 2;
    private static final int SYS_THESAURUS_QUASI_SYNONYM = 3;
    private DefaultProfile profile;

    public DefaultProfileInfo(DefaultProfile profile) {
        this.profile = profile;
    }

    public DefaultProfileInfo(List inheritThesaurusList, boolean inheritStopword, boolean inheritBannedWord, boolean inheritRecommend, boolean inheritRedirct) throws IRException {
        this.profile = ProfileSettingManager.createDefaultProfile(inheritThesaurusList, inheritStopword, inheritBannedWord, inheritRecommend, inheritRedirct);
    }

    public DefaultProfileInfo() {
    }

    public void setStopword(boolean inherit) {
        this.profile.setInheritStopword(inherit);
    }

    public void setBannedWord(boolean inherit) {
        this.profile.setInheritBannedWord(inherit);
    }

    public void setRecommend(boolean inherit) {
        this.profile.setInheritRecommend(inherit);
    }

    public void setRedirect(boolean inherit) {
        this.profile.setInheritRedirect(inherit);
    }

    public void setThesaurus(List inheritThesaurusList) {
        this.profile.getInheritThesaurus().clear();
        int i = 0;
        while (i < inheritThesaurusList.size()) {
            this.profile.getInheritThesaurus().add((InheritThesaurus)inheritThesaurusList.get(i));
            ++i;
        }
    }

    public void setThesaurus(String[] thesaurusNames, boolean[] inheritThesaurusList) throws IOException {
        this.profile.getInheritThesaurus().clear();
        ObjectFactory objectFactory = new ObjectFactory();
        int i = 0;
        while (i < thesaurusNames.length) {
            InheritThesaurus inheritThesaurus = null;
            try {
                inheritThesaurus = objectFactory.createInheritThesaurus();
            }
            catch (JAXBException e) {
                TraverseException tr = new TraverseException((Throwable)e);
                throw new IOException(tr.chainMessage());
            }
            inheritThesaurus.setName(thesaurusNames[i]);
            inheritThesaurus.setInherit(inheritThesaurusList[i]);
            this.profile.getInheritThesaurus().add(inheritThesaurus);
            ++i;
        }
    }

    public boolean getStopword() {
        return this.profile.isInheritStopword();
    }

    public boolean getBannedWord() {
        return this.profile.isInheritBannedWord();
    }

    public boolean getRecommend() {
        return this.profile.isInheritRecommend();
    }

    public boolean getRedirect() {
        return this.profile.isInheritRedirect();
    }

    public boolean[] getThesaurus() {
        List inheritThesaurusList = this.profile.getInheritThesaurus();
        boolean[] ret = new boolean[inheritThesaurusList.size()];
        int i = 0;
        while (i < inheritThesaurusList.size()) {
            ret[i] = ((InheritThesaurus)inheritThesaurusList.get(i)).isInherit();
            ++i;
        }
        return ret;
    }

    public boolean getEquivSynonym() {
        List inheritThesaurusList = this.profile.getInheritThesaurus();
        return ((InheritThesaurus)inheritThesaurusList.get(0)).isInherit();
    }

    public boolean getQuasiSynonym() {
        List inheritThesaurusList = this.profile.getInheritThesaurus();
        return ((InheritThesaurus)inheritThesaurusList.get(2)).isInherit();
    }

    public void serialize(OutputStream out) throws IOException {
        List inheritThesaurusList = this.profile.getInheritThesaurus();
        int thesaurusSize = inheritThesaurusList.size();
        ByteUtil.writeInt((OutputStream)out, (int)thesaurusSize);
        int i = 0;
        while (i < thesaurusSize) {
            InheritThesaurusType inheritTehsaurus = (InheritThesaurusType)inheritThesaurusList.get(i);
            ByteUtil.writeString((OutputStream)out, (String)inheritTehsaurus.getName());
            ByteUtil.writeBoolean((OutputStream)out, (boolean)inheritTehsaurus.isInherit());
            ++i;
        }
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.isInheritStopword());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.isInheritBannedWord());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.isInheritRecommend());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.isInheritRedirect());
    }

    public void deserialize(InputStream in) throws IOException {
        int inheritThesaurusSize = ByteUtil.readInt((InputStream)in);
        ArrayList<InheritThesaurus> inheritThesaurusList = new ArrayList<InheritThesaurus>(inheritThesaurusSize);
        ObjectFactory objectFactory = new ObjectFactory();
        int i = 0;
        while (i < inheritThesaurusSize) {
            InheritThesaurus inheritThesaurus = null;
            try {
                inheritThesaurus = objectFactory.createInheritThesaurus();
            }
            catch (JAXBException e) {
                TraverseException tr = new TraverseException((Throwable)e);
                throw new IOException(tr.chainMessage());
            }
            inheritThesaurus.setName(ByteUtil.readString((InputStream)in));
            inheritThesaurus.setInherit(ByteUtil.readBoolean((InputStream)in));
            inheritThesaurusList.add(inheritThesaurus);
            ++i;
        }
        boolean inheritStopword = ByteUtil.readBoolean((InputStream)in);
        boolean inheritBannedWord = ByteUtil.readBoolean((InputStream)in);
        boolean inheritRecommend = ByteUtil.readBoolean((InputStream)in);
        boolean inheritRedirct = ByteUtil.readBoolean((InputStream)in);
        try {
            this.profile = ProfileSettingManager.createDefaultProfile(inheritThesaurusList, inheritStopword, inheritBannedWord, inheritRecommend, inheritRedirct);
        }
        catch (IRException e) {
            TraverseException tr = new TraverseException((Throwable)e);
            throw new IOException(tr.chainMessage());
        }
    }

    public Transmitable getInstance() {
        return new DefaultProfileInfo();
    }

    public boolean isNull() {
        return false;
    }

    public DefaultProfile getProfile() {
        return this.profile;
    }

    public void setCategoryRanking(boolean inherit, boolean use) {
    }

    public void setDocumentRanking(boolean inherit, boolean use) {
    }

    public void setRankingModel(boolean use) {
    }

    public void setThesaurus(boolean[] inherit, boolean[] use) {
        List thesaurusList = this.profile.getInheritThesaurus();
        int i = 0;
        while (i < inherit.length) {
            InheritThesaurus thesaurus = (InheritThesaurus)thesaurusList.get(i);
            thesaurus.setInherit(inherit[i]);
            ++i;
        }
    }

    public void setBannedWord(boolean inherit, boolean use) {
        this.setBannedWord(inherit);
    }

    public void setStopword(boolean inherit, boolean use) {
        this.setStopword(inherit);
    }

    public void setRecommend(boolean inherit, boolean use) {
        this.setRecommend(inherit);
    }

    public void setRedirect(boolean inherit, boolean use) {
        this.setRedirect(inherit);
    }

    public boolean isInheritBannedWord() {
        return this.getBannedWord();
    }

    public boolean isInheritCategoryRanking() {
        return false;
    }

    public boolean isInheritDocumentRanking() {
        return false;
    }

    public boolean isInheritEquivSynonym() {
        return this.getEquivSynonym();
    }

    public boolean isInheritQuasiSynonym() {
        return this.getQuasiSynonym();
    }

    public boolean isInheritRecommend() {
        return this.getRecommend();
    }

    public boolean isInheritRedirect() {
        return this.getRedirect();
    }

    public boolean isInheritStopWord() {
        return this.getStopword();
    }

    public void setEquivSynonym(boolean inherit, boolean use) {
        InheritThesaurus sys_thesaurus;
        List inheritThesauruses = this.profile.getInheritThesaurus();
        InheritThesaurus thesaurus = (InheritThesaurus)inheritThesauruses.get(0);
        if (thesaurus != null) {
            thesaurus.setInherit(inherit);
        }
        if ((sys_thesaurus = (InheritThesaurus)inheritThesauruses.get(1)) != null) {
            sys_thesaurus.setInherit(inherit);
        }
    }

    public void setQuasiSynonym(boolean inherit, boolean use) {
        InheritThesaurus sys_thesaurus;
        List inheritThesauruses = this.profile.getInheritThesaurus();
        InheritThesaurus thesaurus = (InheritThesaurus)inheritThesauruses.get(2);
        if (thesaurus != null) {
            thesaurus.setInherit(inherit);
        }
        if ((sys_thesaurus = (InheritThesaurus)inheritThesauruses.get(3)) != null) {
            sys_thesaurus.setInherit(inherit);
        }
    }
}

