/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.collection;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.collection.ProfileInfoType;
import com.diquest.ir.common.setting.manager.ProfileSettingManager;
import com.diquest.ir.common.setting.profile.BannedWord;
import com.diquest.ir.common.setting.profile.CategoryRanking;
import com.diquest.ir.common.setting.profile.DocumentRanking;
import com.diquest.ir.common.setting.profile.ObjectFactory;
import com.diquest.ir.common.setting.profile.Profile;
import com.diquest.ir.common.setting.profile.RankingModel;
import com.diquest.ir.common.setting.profile.Recommend;
import com.diquest.ir.common.setting.profile.Redirect;
import com.diquest.ir.common.setting.profile.Stopword;
import com.diquest.ir.common.setting.profile.Thesaurus;
import com.diquest.ir.common.setting.profile.ThesaurusList;
import com.diquest.ir.common.setting.profile.ThesaurusType;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.TraverseException;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.JAXBException;

public class ProfileInfo
extends ProfileInfoType
implements Serializable {
    private static final long serialVersionUID = -2598514405732044597L;
    private static final int THESAURUS_EQUIV_SYNONYM = 0;
    private static final int SYS_THESAURUS_EQUIV_SYNONYM = 1;
    private static final int THESAURUS_QUASI_SYNONYM = 2;
    private static final int SYS_THESAURUS_QUASI_SYNONYM = 3;
    private Profile profile;

    public ProfileInfo(Profile profile) {
        this.profile = profile;
    }

    public ProfileInfo(String profileID) throws IRException {
        this.profile = ProfileSettingManager.createProfile(profileID);
    }

    public ProfileInfo() {
    }

    public void setRankingModel(boolean use) {
        this.profile.getRankingModel().setUse(use);
    }

    public void setCategoryRanking(boolean inherit, boolean use) {
        this.profile.getCategoryRanking().setInherit(inherit);
        this.profile.getCategoryRanking().setUse(use);
    }

    public void setDocumentRanking(boolean inherit, boolean use) {
        this.profile.getDocumentRanking().setInherit(inherit);
        this.profile.getDocumentRanking().setUse(use);
    }

    public void setThesaurus(List thesauruses) {
        this.profile.getThesaurusList().getThesaurus().clear();
        int i = 0;
        while (i < thesauruses.size()) {
            this.profile.getThesaurusList().getThesaurus().add((Thesaurus)thesauruses.get(i));
            ++i;
        }
    }

    public void setThesaurus(boolean[] inherit, boolean[] use) {
        List thesaurusList = this.profile.getThesaurusList().getThesaurus();
        int i = 0;
        while (i < inherit.length) {
            Thesaurus thesaurus = (Thesaurus)thesaurusList.get(i);
            thesaurus.setInherit(inherit[i]);
            thesaurus.setUse(use[i]);
            ++i;
        }
    }

    public void setEquivSynonym(boolean inherit, boolean use) {
        Thesaurus sys_thesaurus;
        List thesauruses = this.profile.getThesaurusList().getThesaurus();
        Thesaurus thesaurus = (Thesaurus)thesauruses.get(0);
        if (thesaurus != null) {
            thesaurus.setInherit(inherit);
            thesaurus.setUse(use);
        }
        if ((sys_thesaurus = (Thesaurus)thesauruses.get(1)) != null) {
            sys_thesaurus.setInherit(inherit);
            sys_thesaurus.setUse(use);
        }
    }

    public void setQuasiSynonym(boolean inherit, boolean use) {
        Thesaurus sys_thesaurus;
        List thesauruses = this.profile.getThesaurusList().getThesaurus();
        Thesaurus thesaurus = (Thesaurus)thesauruses.get(2);
        if (thesaurus != null) {
            thesaurus.setInherit(inherit);
            thesaurus.setUse(use);
        }
        if ((sys_thesaurus = (Thesaurus)thesauruses.get(3)) != null) {
            sys_thesaurus.setInherit(inherit);
            sys_thesaurus.setUse(use);
        }
    }

    public void setStopword(boolean inherit, boolean use) {
        this.profile.getStopword().setInherit(inherit);
        this.profile.getStopword().setUse(use);
    }

    public void setBannedWord(boolean inherit, boolean use) {
        this.profile.getBannedWord().setInherit(inherit);
        this.profile.getBannedWord().setUse(use);
    }

    public void setRecommend(boolean inherit, boolean use) {
        this.profile.getRecommend().setInherit(inherit);
        this.profile.getRecommend().setUse(use);
    }

    public void setRedirect(boolean inherit, boolean use) {
        this.profile.getRedirect().setInherit(inherit);
        this.profile.getRedirect().setUse(use);
    }

    public RankingModel getRankingModel() {
        return (RankingModel)this.profile.getRankingModel();
    }

    public CategoryRanking getCategoryRanking() {
        return (CategoryRanking)this.profile.getCategoryRanking();
    }

    public DocumentRanking getDocumentRanking() {
        return (DocumentRanking)this.profile.getDocumentRanking();
    }

    public ThesaurusList getThesaurus() {
        return (ThesaurusList)this.profile.getThesaurusList();
    }

    public Thesaurus getEquivSynonym() {
        List thesauruses = this.profile.getThesaurusList().getThesaurus();
        return (Thesaurus)thesauruses.get(0);
    }

    public Thesaurus getQuasiSynonym() {
        List thesauruses = this.profile.getThesaurusList().getThesaurus();
        return (Thesaurus)thesauruses.get(2);
    }

    public Stopword getStopword() {
        return (Stopword)this.profile.getStopword();
    }

    public BannedWord getBannedWord() {
        return (BannedWord)this.profile.getBannedWord();
    }

    public Recommend getRecommend() {
        return (Recommend)this.profile.getRecommend();
    }

    public Redirect getRedirect() {
        return (Redirect)this.profile.getRedirect();
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.profile.getId());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getRankingModel().isUse());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getCategoryRanking().isInherit());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getCategoryRanking().isUse());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getDocumentRanking().isInherit());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getDocumentRanking().isUse());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getStopword().isInherit());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getStopword().isUse());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getBannedWord().isInherit());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getBannedWord().isUse());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getRecommend().isInherit());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getRecommend().isUse());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getRedirect().isInherit());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.profile.getRedirect().isUse());
        List thesauruses = this.profile.getThesaurusList().getThesaurus();
        int thesaurusSize = thesauruses.size();
        ByteUtil.writeInt((OutputStream)out, (int)thesaurusSize);
        int i = 0;
        while (i < thesaurusSize) {
            ThesaurusType tehsaurus = (ThesaurusType)thesauruses.get(i);
            ByteUtil.writeString((OutputStream)out, (String)tehsaurus.getName());
            ByteUtil.writeBoolean((OutputStream)out, (boolean)tehsaurus.isInherit());
            ByteUtil.writeBoolean((OutputStream)out, (boolean)tehsaurus.isUse());
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        String profileID = ByteUtil.readString((InputStream)in);
        try {
            this.profile = ProfileSettingManager.createProfile(profileID);
        }
        catch (IRException e) {
            TraverseException tr = new TraverseException((Throwable)e);
            throw new IOException(tr.chainMessage());
        }
        this.setRankingModel(ByteUtil.readBoolean((InputStream)in));
        this.setCategoryRanking(ByteUtil.readBoolean((InputStream)in), ByteUtil.readBoolean((InputStream)in));
        this.setDocumentRanking(ByteUtil.readBoolean((InputStream)in), ByteUtil.readBoolean((InputStream)in));
        this.setStopword(ByteUtil.readBoolean((InputStream)in), ByteUtil.readBoolean((InputStream)in));
        this.setBannedWord(ByteUtil.readBoolean((InputStream)in), ByteUtil.readBoolean((InputStream)in));
        this.setRecommend(ByteUtil.readBoolean((InputStream)in), ByteUtil.readBoolean((InputStream)in));
        this.setRedirect(ByteUtil.readBoolean((InputStream)in), ByteUtil.readBoolean((InputStream)in));
        int thesaurusSize = ByteUtil.readInt((InputStream)in);
        ObjectFactory objectFactory = new ObjectFactory();
        ThesaurusList thesaurusList = null;
        try {
            thesaurusList = objectFactory.createThesaurusList();
            List thesauruses = thesaurusList.getThesaurus();
            int i = 0;
            while (i < thesaurusSize) {
                Thesaurus thesaurus = null;
                thesaurus = objectFactory.createThesaurus();
                thesaurus.setName(ByteUtil.readString((InputStream)in));
                thesaurus.setInherit(ByteUtil.readBoolean((InputStream)in));
                thesaurus.setUse(ByteUtil.readBoolean((InputStream)in));
                thesauruses.add(thesaurus);
                ++i;
            }
            this.setThesaurus(thesauruses);
        }
        catch (JAXBException e) {
            TraverseException tr = new TraverseException((Throwable)e);
            throw new IOException(tr.chainMessage());
        }
    }

    public Transmitable getInstance() {
        return new ProfileInfo();
    }

    public boolean isNull() {
        return false;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public boolean isInheritBannedWord() {
        return this.getBannedWord().isInherit();
    }

    public boolean isInheritCategoryRanking() {
        return this.getCategoryRanking().isInherit();
    }

    public boolean isInheritDocumentRanking() {
        return this.getDocumentRanking().isInherit();
    }

    public boolean isInheritEquivSynonym() {
        return this.getEquivSynonym().isInherit();
    }

    public boolean isInheritQuasiSynonym() {
        return this.getQuasiSynonym().isInherit();
    }

    public boolean isInheritRecommend() {
        return this.getRecommend().isInherit();
    }

    public boolean isInheritRedirect() {
        return this.getRedirect().isInherit();
    }

    public boolean isInheritStopWord() {
        return this.getStopword().isInherit();
    }
}

