/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.dictionary;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.CharUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class BannedWordDictionary
extends Transmitable {
    public static final int DEFAULT_BUCKET_SIZE = 16384;
    private static final int HASH_SEED = 1159241;
    private int bucketSize;
    private int[] hashHeadPosition;
    private int[] next;
    private int[] wordPos;
    private int capacity;
    private int used;
    private char[] wordData;
    private int wordDataCapacity;
    private int wordDataUsed;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.dictionary.BannedWordDictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BannedWordDictionary() {
    }

    public BannedWordDictionary(int bucketSize) {
        this.init(bucketSize);
    }

    private void init(int size) {
        if (size == 0) {
            size = 1;
        }
        this.capacity = this.bucketSize = size;
        this.wordDataCapacity = this.capacity * 3;
        this.used = 0;
        this.wordDataUsed = 0;
        this.hashHeadPosition = new int[this.bucketSize];
        this.wordPos = new int[this.capacity];
        this.next = new int[this.capacity];
        this.wordData = new char[this.wordDataCapacity];
        int i = 0;
        while (i < this.bucketSize) {
            this.hashHeadPosition[i] = -1;
            ++i;
        }
    }

    public final void add(String str) {
        this.add(str.toCharArray(), 0, str.length());
    }

    /*
     * Unable to fully structure code
     */
    private void add(char[] symbol, int begin, int length) {
        if (!BannedWordDictionary.$assertionsDisabled && length <= 0) {
            throw new AssertionError();
        }
        symbol = CharUtil.toUpperCase((char[])symbol, (int)begin, (int)length);
        hashValue = this.bitwisehash(symbol, begin, length);
        previousLink = -1;
        currentLink = this.hashHeadPosition[hashValue];
        if (BannedWordDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used) ** GOTO lbl13
        throw new AssertionError((Object)("1," + currentLink + "," + this.used));
lbl-1000:
        // 1 sources

        {
            previousLink = currentLink;
            currentLink = this.next[currentLink];
            if (!(BannedWordDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used)) {
                throw new AssertionError((Object)("2," + currentLink + "," + this.used));
            }
lbl13:
            // 3 sources

            ** while (currentLink != -1 && !this.matchWord((char[])symbol, (int)begin, (int)length, (int)currentLink))
        }
lbl14:
        // 1 sources

        if (currentLink == -1) {
            currentLink = this.getNextBucket();
            this.storeWord(currentLink, symbol, begin, length);
            this.next[currentLink] = -1;
            if (previousLink == -1) {
                this.hashHeadPosition[hashValue] = currentLink;
            } else {
                this.next[previousLink] = currentLink;
            }
            if (!(BannedWordDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used)) {
                throw new AssertionError((Object)("3," + currentLink + "," + this.used));
            }
        } else {
            System.out.println("Cannot use duplicated word as a key : " + new String(symbol, begin, length));
            return;
        }
    }

    public boolean find(String str) {
        return this.find(str.toCharArray(), 0, str.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean find(char[] symbol, int begin, int length) {
        if (!BannedWordDictionary.$assertionsDisabled && length <= 0) {
            throw new AssertionError();
        }
        symbol = CharUtil.getUpperCase((char[])symbol, (int)begin, (int)length);
        hashValue = this.bitwisehash(symbol, 0, symbol.length);
        currentLink = this.hashHeadPosition[hashValue];
        if (BannedWordDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used) ** GOTO lbl11
        throw new AssertionError((Object)("1," + currentLink + "," + this.used));
lbl-1000:
        // 1 sources

        {
            currentLink = this.next[currentLink];
            if (!(BannedWordDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used)) {
                throw new AssertionError((Object)("2," + currentLink + "," + this.used));
            }
lbl11:
            // 3 sources

            ** while (currentLink != -1 && !this.matchWord((char[])symbol, (int)0, (int)symbol.length, (int)currentLink))
        }
lbl12:
        // 1 sources

        return currentLink != -1;
    }

    private int getNextBucket() {
        if (this.used >= this.capacity) {
            this.capacity = (int)((double)this.capacity * 1.2);
            int[] newWordPos = new int[this.capacity];
            System.arraycopy(this.wordPos, 0, newWordPos, 0, this.used);
            int[] newNext = new int[this.capacity];
            System.arraycopy(this.next, 0, newNext, 0, this.used);
            this.wordPos = newWordPos;
            this.next = newNext;
        }
        return this.used++;
    }

    private int bitwisehash(char[] word, int begin, int length) {
        int h = 1159241;
        int i = begin;
        while (i < begin + length) {
            h ^= (h << 5) + word[i] + (h >> 2);
            ++i;
        }
        return (h & Integer.MAX_VALUE) % this.bucketSize;
    }

    private boolean matchWord(char[] symbol, int begin, int length, int wordID) {
        int pos;
        if (!($assertionsDisabled || wordID >= 0 && wordID < this.used)) {
            throw new AssertionError((Object)(String.valueOf(wordID) + "," + this.used));
        }
        int wordLength = (wordID == this.used - 1 ? this.wordDataUsed : this.wordPos[wordID + 1]) - (pos = this.wordPos[wordID]);
        if (length == wordLength) {
            int i = 0;
            while (i < length) {
                if (symbol[begin + i] != this.wordData[pos + i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void storeWord(int currentLink, char[] symbol, int begin, int length) {
        if (this.wordDataUsed + length >= this.wordDataCapacity) {
            this.wordDataCapacity = (int)((double)(this.wordDataUsed + length) * 1.2);
            char[] newWordData = new char[this.wordDataCapacity];
            System.arraycopy(this.wordData, 0, newWordData, 0, this.wordDataUsed);
            this.wordData = newWordData;
        }
        this.wordPos[currentLink] = this.wordDataUsed;
        int i = 0;
        while (i < length) {
            this.wordData[this.wordDataUsed] = symbol[begin + i];
            ++this.wordDataUsed;
            ++i;
        }
    }

    public void deserialize(InputStream is) throws IOException {
        this.bucketSize = ByteUtil.readInt((InputStream)is);
        this.hashHeadPosition = new int[this.bucketSize];
        int i = 0;
        while (i < this.bucketSize) {
            this.hashHeadPosition[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.used = this.capacity = ByteUtil.readInt((InputStream)is);
        this.wordPos = new int[this.used];
        i = 0;
        while (i < this.used) {
            this.wordPos[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.next = new int[this.used];
        i = 0;
        while (i < this.used) {
            this.next[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.wordDataUsed = this.wordDataCapacity = ByteUtil.readInt((InputStream)is);
        this.wordData = new char[this.wordDataUsed];
        i = 0;
        while (i < this.wordDataUsed) {
            this.wordData[i] = ByteUtil.readChar((InputStream)is);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new BannedWordDictionary();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream os) throws IOException {
        ByteUtil.writeInt((OutputStream)os, (int)this.bucketSize);
        int i = 0;
        while (i < this.bucketSize) {
            ByteUtil.writeInt((OutputStream)os, (int)this.hashHeadPosition[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)os, (int)this.used);
        i = 0;
        while (i < this.used) {
            ByteUtil.writeInt((OutputStream)os, (int)this.wordPos[i]);
            ++i;
        }
        i = 0;
        while (i < this.used) {
            ByteUtil.writeInt((OutputStream)os, (int)this.next[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)os, (int)this.wordDataUsed);
        i = 0;
        while (i < this.wordDataUsed) {
            ByteUtil.writeChar((OutputStream)os, (char)this.wordData[i]);
            ++i;
        }
    }

    public void printAll() {
        int i = 0;
        while (i < this.hashHeadPosition.length) {
            if (this.hashHeadPosition[i] != -1) {
                int wordID = this.hashHeadPosition[i];
                int wordP = this.wordPos[wordID];
                int wordLength = (wordID == this.used - 1 ? this.wordDataUsed : this.wordPos[wordID + 1]) - wordP;
                System.out.println(new String(this.wordData, wordP, wordLength));
                while (this.next[wordID] >= 0) {
                    wordID = this.next[wordID];
                    wordP = this.wordPos[wordID];
                    wordLength = (wordID == this.used - 1 ? this.wordDataUsed : this.wordPos[wordID + 1]) - wordP;
                    System.out.println(new String(this.wordData, wordP, wordLength));
                }
            }
            ++i;
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            int currentWordID = 0;

            public void remove() {
            }

            public boolean hasNext() {
                return BannedWordDictionary.this.used > this.currentWordID;
            }

            public Object next() {
                int wordP = BannedWordDictionary.this.wordPos[this.currentWordID];
                int wordLength = (this.currentWordID == BannedWordDictionary.this.used - 1 ? BannedWordDictionary.this.wordDataUsed : BannedWordDictionary.this.wordPos[this.currentWordID + 1]) - wordP;
                ++this.currentWordID;
                return new String(BannedWordDictionary.this.wordData, wordP, wordLength);
            }
        };
    }
}

