/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.dictionary;

import com.diquest.ir.common.msg.dictionary.CategoryRankingElement;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.CharUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CategoryRankingDictionary
extends Transmitable {
    public static final int DEFAULT_BUCKET_SIZE = 16384;
    private static final int HASH_SEED = 1159241;
    private int bucketSize;
    private int[] hashHeadPosition;
    private int[] next;
    private int[] wordPos;
    private int[] valuePos;
    private int capacity;
    private int used;
    private char[] wordData;
    private int wordDataCapacity;
    private int wordDataUsed;
    private byte[] valueData;
    private int valueDataCapacity;
    private int valueDataUsed;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.dictionary.CategoryRankingDictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CategoryRankingDictionary() {
    }

    public CategoryRankingDictionary(int bucketSize) {
        this.init(bucketSize);
    }

    protected void init(int size) {
        if (size == 0) {
            size = 1;
        }
        this.capacity = this.bucketSize = size;
        this.wordDataCapacity = this.capacity * 3;
        this.valueDataCapacity = this.capacity * 100;
        this.used = 0;
        this.wordDataUsed = 0;
        this.valueDataUsed = 0;
        this.hashHeadPosition = new int[this.bucketSize];
        this.wordPos = new int[this.capacity];
        this.valuePos = new int[this.capacity];
        this.next = new int[this.capacity];
        this.wordData = new char[this.wordDataCapacity];
        this.valueData = new byte[this.valueDataCapacity];
        int i = 0;
        while (i < this.bucketSize) {
            this.hashHeadPosition[i] = -1;
            ++i;
        }
    }

    public final void add(CategoryRankingElement rankingElement) throws IOException {
        this.add(rankingElement.getKeyword(), rankingElement.serializeValues());
    }

    public final void add(char[] keyword, char[][] category, char[][] field, boolean[] type, int[] weight, long[] start, long[] end) throws IOException {
        this.add(keyword, CategoryRankingElement.createBytes(category, field, type, weight, start, end));
    }

    /*
     * Unable to fully structure code
     */
    private void add(char[] key, byte[] value) {
        if (!CategoryRankingDictionary.$assertionsDisabled && key.length <= 0) {
            throw new AssertionError();
        }
        key = CharUtil.toUpperCase((char[])key);
        hashValue = this.bitwisehash(key, 0, key.length);
        previousLink = -1;
        currentLink = this.hashHeadPosition[hashValue];
        if (CategoryRankingDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used) ** GOTO lbl13
        throw new AssertionError((Object)("1," + currentLink + "," + this.used));
lbl-1000:
        // 1 sources

        {
            previousLink = currentLink;
            currentLink = this.next[currentLink];
            if (!(CategoryRankingDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used)) {
                throw new AssertionError((Object)("2," + currentLink + "," + this.used));
            }
lbl13:
            // 3 sources

            ** while (currentLink != -1 && !this.matchWord((char[])key, (int)0, (int)key.length, (int)currentLink))
        }
lbl14:
        // 1 sources

        if (currentLink == -1) {
            currentLink = this.getNextBucket();
            this.storeWord(currentLink, key, 0, key.length);
            this.next[currentLink] = -1;
            if (previousLink == -1) {
                this.hashHeadPosition[hashValue] = currentLink;
            } else {
                this.next[previousLink] = currentLink;
            }
            this.storeValue(currentLink, value, 0, value.length);
            if (!(CategoryRankingDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used)) {
                throw new AssertionError((Object)("3," + currentLink + "," + this.used));
            }
        } else {
            System.out.println("Cannot use duplicated word as a key : " + new String(key, 0, key.length));
            return;
        }
    }

    public CategoryRankingElement get(char[] keyword) throws IOException {
        byte[] values = this.getInternal(keyword);
        if (values == null) {
            return null;
        }
        return new CategoryRankingElement(keyword, values);
    }

    public CategoryRankingElement get(char[] keyword, int offset, int length) throws IOException {
        char[] nkeyword = new char[length];
        System.arraycopy(keyword, offset, nkeyword, 0, length);
        byte[] values = this.getInternal(nkeyword);
        if (values == null) {
            return null;
        }
        return new CategoryRankingElement(nkeyword, values);
    }

    public CategoryRankingElement get(String keyword) throws IOException {
        return this.get(keyword.toCharArray());
    }

    /*
     * Unable to fully structure code
     */
    public byte[] getInternal(char[] key) {
        if (!CategoryRankingDictionary.$assertionsDisabled && key.length <= 0) {
            throw new AssertionError();
        }
        key = CharUtil.getUpperCase((char[])key, (int)0, (int)key.length);
        hashValue = this.bitwisehash(key, 0, key.length);
        currentLink = this.hashHeadPosition[hashValue];
        if (CategoryRankingDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used) ** GOTO lbl11
        throw new AssertionError((Object)("1," + currentLink + "," + this.used));
lbl-1000:
        // 1 sources

        {
            currentLink = this.next[currentLink];
            if (!(CategoryRankingDictionary.$assertionsDisabled || currentLink >= -1 && currentLink < this.used)) {
                throw new AssertionError((Object)("2," + currentLink + "," + this.used));
            }
lbl11:
            // 3 sources

            ** while (currentLink != -1 && !this.matchWord((char[])key, (int)0, (int)key.length, (int)currentLink))
        }
lbl12:
        // 1 sources

        if (currentLink == -1) {
            return null;
        }
        vPos = this.valuePos[currentLink];
        vLength = (currentLink == this.used - 1 ? this.valueDataUsed : this.valuePos[currentLink + 1]) - vPos;
        value = new byte[vLength];
        System.arraycopy(this.valueData, vPos, value, 0, vLength);
        return value;
    }

    private int getNextBucket() {
        if (this.used >= this.capacity) {
            this.capacity = (int)((double)this.capacity * 1.2);
            int[] newWordPos = new int[this.capacity];
            System.arraycopy(this.wordPos, 0, newWordPos, 0, this.used);
            int[] newValuePos = new int[this.capacity];
            System.arraycopy(this.valuePos, 0, newValuePos, 0, this.used);
            int[] newNext = new int[this.capacity];
            System.arraycopy(this.next, 0, newNext, 0, this.used);
            this.wordPos = newWordPos;
            this.next = newNext;
            this.valuePos = newValuePos;
        }
        return this.used++;
    }

    private int bitwisehash(char[] word, int begin, int length) {
        int h = 1159241;
        int i = begin;
        while (i < begin + length) {
            h ^= (h << 5) + word[i] + (h >> 2);
            ++i;
        }
        return (h & Integer.MAX_VALUE) % this.bucketSize;
    }

    public void printEntries() {
        int i = 0;
        while (i < this.used) {
            int position = this.hashHeadPosition[i];
            while (position != -1) {
                int pos = this.wordPos[i];
                int wordLength = (i == this.used - 1 ? this.wordDataUsed : this.wordPos[i + 1]) - pos;
                System.out.println(String.valueOf(i) + " : " + new String(this.wordData, pos, wordLength));
                position = this.next[position];
            }
            ++i;
        }
    }

    private boolean matchWord(char[] symbol, int begin, int length, int wordID) {
        int pos;
        if (!($assertionsDisabled || wordID >= 0 && wordID < this.used)) {
            throw new AssertionError((Object)(String.valueOf(wordID) + "," + this.used));
        }
        int wordLength = (wordID == this.used - 1 ? this.wordDataUsed : this.wordPos[wordID + 1]) - (pos = this.wordPos[wordID]);
        if (length == wordLength) {
            int i = 0;
            while (i < length) {
                if (symbol[begin + i] != this.wordData[pos + i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void storeWord(int currentLink, char[] symbol, int begin, int length) {
        if (this.wordDataUsed + length >= this.wordDataCapacity) {
            this.wordDataCapacity = (int)((double)(this.wordDataUsed + length) * 1.2);
            char[] newWordData = new char[this.wordDataCapacity];
            System.arraycopy(this.wordData, 0, newWordData, 0, this.wordDataUsed);
            this.wordData = newWordData;
        }
        this.wordPos[currentLink] = this.wordDataUsed;
        int i = 0;
        while (i < length) {
            this.wordData[this.wordDataUsed] = symbol[begin + i];
            ++this.wordDataUsed;
            ++i;
        }
    }

    private void storeValue(int currentLink, byte[] value, int start, int length) {
        if (this.valueDataUsed + length >= this.valueDataCapacity) {
            this.valueDataCapacity = (int)((double)(this.valueDataUsed + length) * 1.2);
            byte[] newValueData = new byte[this.valueDataCapacity];
            System.arraycopy(this.valueData, 0, newValueData, 0, this.valueDataUsed);
            this.valueData = newValueData;
        }
        this.valuePos[currentLink] = this.valueDataUsed;
        int i = 0;
        while (i < length) {
            this.valueData[this.valueDataUsed] = value[start + i];
            ++this.valueDataUsed;
            ++i;
        }
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream os) throws IOException {
        ByteUtil.writeInt((OutputStream)os, (int)this.bucketSize);
        int i = 0;
        while (i < this.bucketSize) {
            ByteUtil.writeInt((OutputStream)os, (int)this.hashHeadPosition[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)os, (int)this.used);
        i = 0;
        while (i < this.used) {
            ByteUtil.writeInt((OutputStream)os, (int)this.wordPos[i]);
            ++i;
        }
        i = 0;
        while (i < this.used) {
            ByteUtil.writeInt((OutputStream)os, (int)this.valuePos[i]);
            ++i;
        }
        i = 0;
        while (i < this.used) {
            ByteUtil.writeInt((OutputStream)os, (int)this.next[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)os, (int)this.wordDataUsed);
        i = 0;
        while (i < this.wordDataUsed) {
            ByteUtil.writeChar((OutputStream)os, (char)this.wordData[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)os, (int)this.valueDataUsed);
        i = 0;
        while (i < this.valueDataUsed) {
            ByteUtil.writeByte((OutputStream)os, (byte)this.valueData[i]);
            ++i;
        }
    }

    public void deserialize(InputStream is) throws IOException {
        this.bucketSize = ByteUtil.readInt((InputStream)is);
        this.hashHeadPosition = new int[this.bucketSize];
        int i = 0;
        while (i < this.bucketSize) {
            this.hashHeadPosition[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.used = this.capacity = ByteUtil.readInt((InputStream)is);
        this.wordPos = new int[this.used];
        i = 0;
        while (i < this.used) {
            this.wordPos[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.valuePos = new int[this.used];
        i = 0;
        while (i < this.used) {
            this.valuePos[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.next = new int[this.used];
        i = 0;
        while (i < this.used) {
            this.next[i] = ByteUtil.readInt((InputStream)is);
            ++i;
        }
        this.wordDataUsed = this.wordDataCapacity = ByteUtil.readInt((InputStream)is);
        this.wordData = new char[this.wordDataUsed];
        i = 0;
        while (i < this.wordDataUsed) {
            this.wordData[i] = ByteUtil.readChar((InputStream)is);
            ++i;
        }
        this.valueDataUsed = this.valueDataCapacity = ByteUtil.readInt((InputStream)is);
        this.valueData = new byte[this.valueDataUsed];
        i = 0;
        while (i < this.valueDataUsed) {
            this.valueData[i] = ByteUtil.readByte((InputStream)is);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new CategoryRankingDictionary();
    }
}

