/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.dictionary;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRanking;
import com.diquest.ir.util.msg.Transmitable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class CategoryRankingElement
extends Transmitable {
    private char[] keyword;
    private int categories;
    private char[][] category;
    private char[][] field;
    private byte[] type;
    private int[] weight;
    private long[] start;
    private long[] end;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.dictionary.CategoryRankingElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CategoryRankingElement() {
    }

    public CategoryRankingElement(char[] keyword, char[][] category, char[][] field, byte[] type, int[] weight, long[] start, long[] end) {
        this.keyword = keyword;
        if (!$assertionsDisabled && category.length != field.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != type.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != weight.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != start.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != end.length) {
            throw new AssertionError();
        }
        this.categories = category.length;
        this.field = field;
        this.category = category;
        this.type = type;
        this.weight = weight;
        this.start = start;
        this.end = end;
    }

    public CategoryRankingElement(String keyword, String[] category, String[] field, byte[] type, int[] weight, long[] start, long[] end) {
        this.keyword = keyword.toCharArray();
        if (!$assertionsDisabled && category.length != field.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != type.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != weight.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != start.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != end.length) {
            throw new AssertionError();
        }
        this.categories = category.length;
        this.category = new char[category.length][];
        int i = 0;
        while (i < category.length) {
            this.category[i] = category[i].toCharArray();
            ++i;
        }
        this.field = new char[field.length][];
        i = 0;
        while (i < field.length) {
            this.field[i] = field[i].toCharArray();
            ++i;
        }
        this.type = type;
        this.weight = weight;
        this.start = start;
        this.end = end;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.keyword);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.categories);
        int i = 0;
        while (i < this.categories) {
            ByteUtil.writeChars((OutputStream)out, (char[])this.category[i]);
            ByteUtil.writeChars((OutputStream)out, (char[])this.field[i]);
            ByteUtil.writeByte((OutputStream)out, (byte)this.type[i]);
            ByteUtil.writeInt((OutputStream)out, (int)this.weight[i]);
            ByteUtil.writeVbLong((OutputStream)out, (long)this.start[i]);
            ByteUtil.writeVbLong((OutputStream)out, (long)this.end[i]);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.keyword = ByteUtil.readChars((InputStream)in);
        this.categories = ByteUtil.readVbInt((InputStream)in);
        this.category = new char[this.categories][];
        this.field = new char[this.categories][];
        this.type = new byte[this.categories];
        this.weight = new int[this.categories];
        this.start = new long[this.categories];
        this.end = new long[this.categories];
        int i = 0;
        while (i < this.categories) {
            this.category[i] = ByteUtil.readChars((InputStream)in);
            this.field[i] = ByteUtil.readChars((InputStream)in);
            this.type[i] = ByteUtil.readByte((InputStream)in);
            this.weight[i] = ByteUtil.readInt((InputStream)in);
            this.start[i] = ByteUtil.readVbLong((InputStream)in);
            this.end[i] = ByteUtil.readVbLong((InputStream)in);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new CategoryRankingElement();
    }

    public boolean isNull() {
        return false;
    }

    public CategoryRankingElement(String keyword, CategoryRanking[] categoryRankings) {
        this.keyword = keyword.toCharArray();
        this.categories = categoryRankings.length;
        this.category = new char[this.categories][];
        this.field = new char[this.categories][];
        this.type = new byte[this.categories];
        this.weight = new int[this.categories];
        this.start = new long[this.categories];
        this.end = new long[this.categories];
        int i = 0;
        while (i < this.categories) {
            this.category[i] = categoryRankings[i].getCategory().toCharArray();
            this.field[i] = categoryRankings[i].getField().toCharArray();
            this.type[i] = categoryRankings[i].getType();
            this.weight[i] = categoryRankings[i].getRank();
            this.start[i] = categoryRankings[i].getStart();
            this.end[i] = categoryRankings[i].getEnd();
            ++i;
        }
    }

    public CategoryRankingElement(char[] keyword, byte[] values) throws IOException {
        this.keyword = keyword;
        this.deserializeValues(values);
    }

    public static byte[] createBytes(char[][] category, char[][] field, boolean[] type, int[] weight, long[] start, long[] end) throws IOException {
        if (!$assertionsDisabled && category.length != field.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != type.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != weight.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != start.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && category.length != end.length) {
            throw new AssertionError();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int categories = category.length;
        baos.write(ByteUtil.writeVbInt((int)categories));
        int i = 0;
        while (i < categories) {
            baos.write(ByteUtil.writeChars((char[])category[i]));
            baos.write(ByteUtil.writeChars((char[])field[i]));
            baos.write(ByteUtil.writeBoolean((boolean)type[i]));
            baos.write(ByteUtil.writeInt((int)weight[i]));
            baos.write(ByteUtil.writeVbLong((long)start[i]));
            baos.write(ByteUtil.writeVbLong((long)end[i]));
            ++i;
        }
        return baos.toByteArray();
    }

    public byte[] serializeValues() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteUtil.writeVbInt((int)this.categories));
        int i = 0;
        while (i < this.categories) {
            baos.write(ByteUtil.writeChars((char[])this.category[i]));
            baos.write(ByteUtil.writeChars((char[])this.field[i]));
            baos.write(ByteUtil.writeByte((byte)this.type[i]));
            baos.write(ByteUtil.writeInt((int)this.weight[i]));
            baos.write(ByteUtil.writeVbLong((long)this.start[i]));
            baos.write(ByteUtil.writeVbLong((long)this.end[i]));
            ++i;
        }
        return baos.toByteArray();
    }

    private void deserializeValues(byte[] values) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(values);
        this.categories = ByteUtil.readVbInt((InputStream)bais);
        this.category = new char[this.categories][];
        this.field = new char[this.categories][];
        this.type = new byte[this.categories];
        this.weight = new int[this.categories];
        this.start = new long[this.categories];
        this.end = new long[this.categories];
        int i = 0;
        while (i < this.categories) {
            this.category[i] = ByteUtil.readChars((InputStream)bais);
            this.field[i] = ByteUtil.readChars((InputStream)bais);
            this.type[i] = ByteUtil.readByte((InputStream)bais);
            this.weight[i] = ByteUtil.readInt((InputStream)bais);
            this.start[i] = ByteUtil.readVbLong((InputStream)bais);
            this.end[i] = ByteUtil.readVbLong((InputStream)bais);
            ++i;
        }
    }

    public char[] getKeyword() {
        return this.keyword;
    }

    public char[][] getField() {
        return this.field;
    }

    public char[] getField(int index) {
        return this.field[index];
    }

    public char[][] getCategory() {
        return this.category;
    }

    public char[] getCategory(int index) {
        return this.category[index];
    }

    public byte[] getType() {
        return this.type;
    }

    public byte getType(int index) {
        return this.type[index];
    }

    public int[] getWeight() {
        return this.weight;
    }

    public int getWeight(int index) {
        return this.weight[index];
    }

    public long[] getStart() {
        return this.start;
    }

    public long getStart(int index) {
        return this.start[index];
    }

    public long[] getEnd() {
        return this.end;
    }

    public long getEnd(int index) {
        return this.end[index];
    }

    public int getCategories() {
        return this.categories;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Keyword : ").append(this.keyword).append("]\n");
        buf.append("[Categories : ").append(this.categories).append("]\n");
        int i = 0;
        while (i < this.categories) {
            buf.append("[Field : ").append(this.field[i]).append("]\n");
            buf.append("[" + i + "]");
            buf.append("[Category : ").append(this.category[i]).append(']');
            buf.append("[Type : ").append(this.type[i]).append(']');
            buf.append("[Weight : ").append(this.weight[i]).append(']');
            buf.append("[Start : ").append(this.start[i]).append(']');
            buf.append("[End : ").append(this.end[i]).append(']');
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public CategoryRankingElement removeExpiredElement() {
        long currentTime = System.currentTimeMillis();
        boolean[] expired = new boolean[this.categories];
        Arrays.fill(expired, false);
        int remainSize = 0;
        int i = 0;
        while (i < this.categories) {
            if (this.start[i] <= currentTime && (this.end[i] == 0L || currentTime <= this.end[i])) {
                ++remainSize;
            } else {
                expired[i] = true;
            }
            ++i;
        }
        if (remainSize == this.categories) {
            return this;
        }
        char[][] ncategory = new char[remainSize][];
        char[][] nfield = new char[remainSize][];
        byte[] ntype = new byte[remainSize];
        int[] nweight = new int[remainSize];
        long[] nstart = new long[remainSize];
        long[] nend = new long[remainSize];
        int currentIndex = 0;
        int i2 = 0;
        while (i2 < this.categories) {
            if (!expired[i2]) {
                ncategory[currentIndex] = this.category[i2];
                nfield[currentIndex] = this.field[i2];
                ntype[currentIndex] = this.type[i2];
                nweight[currentIndex] = this.weight[i2];
                nstart[currentIndex] = this.start[i2];
                nend[currentIndex] = this.end[i2];
                ++currentIndex;
            }
            ++i2;
        }
        CategoryRankingElement newElement = new CategoryRankingElement(this.keyword, ncategory, nfield, ntype, nweight, nstart, nend);
        return newElement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryRankingElement) {
            CategoryRankingElement o = (CategoryRankingElement)((Object)obj);
            if (!Arrays.equals(this.keyword, o.keyword)) {
                return false;
            }
            if (this.category.length != o.category.length) {
                return false;
            }
            int i = 0;
            while (i < this.category.length) {
                if (!Arrays.equals(this.category[i], o.category[i])) {
                    return false;
                }
                ++i;
            }
            if (this.field.length != o.field.length) {
                return false;
            }
            i = 0;
            while (i < this.field.length) {
                if (!Arrays.equals(this.field[i], o.field[i])) {
                    return false;
                }
                ++i;
            }
            if (!Arrays.equals(this.type, o.type)) {
                return false;
            }
            if (!Arrays.equals(this.weight, o.weight)) {
                return false;
            }
            if (!Arrays.equals(this.start, o.start)) {
                return false;
            }
            if (!Arrays.equals(this.end, o.end)) {
                return false;
            }
            return this.categories == o.categories;
        }
        return false;
    }
}

