/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.dictionary;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.msg.dictionary.CategoryRankingElement;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CategoryRankingElementSet
extends Transmitable {
    private CategoryRankingElement[] categoryElements;
    String keyword;
    String[] extractedKeyword;

    public CategoryRankingElementSet() {
        this.categoryElements = null;
    }

    public CategoryRankingElementSet(CategoryRankingElement[] categoryElements, String keyword, String[] extractedKeyword) {
        this.categoryElements = categoryElements;
        this.keyword = keyword;
        this.extractedKeyword = extractedKeyword;
    }

    public CategoryRankingElementSet(CategoryRankingElement[] elements) {
        this.categoryElements = elements;
    }

    public CategoryRankingElementSet(CategoryRankingElement element) {
        this.categoryElements = new CategoryRankingElement[]{element};
    }

    public CategoryRankingElementSet(CategoryRankingElement element, String keyword, String[] extractedKeyword) {
        this.categoryElements = new CategoryRankingElement[]{element};
        this.keyword = keyword;
        this.extractedKeyword = extractedKeyword;
    }

    public CategoryRankingElement[] getCategoryElements() {
        return this.categoryElements;
    }

    public void setCategoryElements(CategoryRankingElement[] categoryElements) {
        this.categoryElements = categoryElements;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String[] getExtractedKeyword() {
        return this.extractedKeyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setExtractedKeyword(String[] extractedKeyword) {
        this.extractedKeyword = extractedKeyword;
    }

    public void removeExpiredElement() {
        CategoryRankingElement[] tempElements = this.categoryElements;
        int i = 0;
        while (i < tempElements.length) {
            if (this.categoryElements[i] != null) {
                this.categoryElements[i] = tempElements[i].removeExpiredElement();
            }
            ++i;
        }
    }

    public int getNumCategoryElements() {
        return this.categoryElements.length;
    }

    public int getNumAllCategory() {
        int num = 0;
        int i = 0;
        while (i < this.categoryElements.length) {
            if (this.categoryElements[i] != null) {
                num += this.categoryElements[i].getCategories();
            }
            ++i;
        }
        return num;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.categoryElements.length) {
            buf.append(this.categoryElements[i].toString());
            ++i;
        }
        return buf.toString();
    }

    public void deserialize(InputStream in) throws IOException {
        int numCategoryElements = ByteUtil.readInt((InputStream)in);
        if (numCategoryElements > 0) {
            this.categoryElements = new CategoryRankingElement[numCategoryElements];
            int i = 0;
            while (i < numCategoryElements) {
                this.categoryElements[i].deserialize(in);
                ++i;
            }
        }
        this.keyword = ByteUtil.readString((InputStream)in);
        int numExtractedKeyword = ByteUtil.readInt((InputStream)in);
        if (numExtractedKeyword > 0) {
            this.extractedKeyword = new String[numExtractedKeyword];
            int i = 0;
            while (i < numExtractedKeyword) {
                this.extractedKeyword[i] = ByteUtil.readString((InputStream)in);
                ++i;
            }
        }
    }

    public Transmitable getInstance() {
        return new CategoryRankingElementSet();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        int i;
        if (this.categoryElements == null || this.categoryElements.length == 0) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.categoryElements.length);
            i = 0;
            while (i < this.categoryElements.length) {
                this.categoryElements[i].serialize(out);
                ++i;
            }
        }
        ByteUtil.writeString((OutputStream)out, (String)this.keyword);
        if (this.extractedKeyword == null || this.extractedKeyword.length == 0) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.extractedKeyword.length);
            i = 0;
            while (i < this.extractedKeyword.length) {
                ByteUtil.writeString((OutputStream)out, (String)this.extractedKeyword[i]);
                ++i;
            }
        }
    }
}

