/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.dictionary;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRanking;
import com.diquest.ir.util.msg.Transmitable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class DocumentRankingElement
extends Transmitable {
    private char[] keyword;
    private char[][] docIDs;
    private byte[] type;
    private int[] weight;
    private long[] start;
    private long[] end;
    private int docIDCount;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.dictionary.DocumentRankingElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.keyword);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.docIDCount);
        int i = 0;
        while (i < this.docIDCount) {
            ByteUtil.writeChars((OutputStream)out, (char[])this.docIDs[i]);
            ByteUtil.writeByte((OutputStream)out, (byte)this.type[i]);
            ByteUtil.writeInt((OutputStream)out, (int)this.weight[i]);
            ByteUtil.writeVbLong((OutputStream)out, (long)this.start[i]);
            ByteUtil.writeVbLong((OutputStream)out, (long)this.end[i]);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.keyword = ByteUtil.readChars((InputStream)in);
        this.docIDCount = ByteUtil.readVbInt((InputStream)in);
        this.docIDs = new char[this.docIDCount][];
        this.type = new byte[this.docIDCount];
        this.weight = new int[this.docIDCount];
        this.start = new long[this.docIDCount];
        this.end = new long[this.docIDCount];
        int i = 0;
        while (i < this.docIDCount) {
            this.docIDs[i] = ByteUtil.readChars((InputStream)in);
            this.type[i] = ByteUtil.readByte((InputStream)in);
            this.weight[i] = ByteUtil.readInt((InputStream)in);
            this.start[i] = ByteUtil.readVbLong((InputStream)in);
            this.end[i] = ByteUtil.readVbLong((InputStream)in);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new DocumentRankingElement();
    }

    public boolean isNull() {
        return false;
    }

    public DocumentRankingElement() {
    }

    public DocumentRankingElement(String keyword, DocumentRanking[] documentRankings) {
        this.keyword = keyword.toCharArray();
        this.docIDCount = documentRankings.length;
        this.docIDs = new char[this.docIDCount][];
        this.type = new byte[this.docIDCount];
        this.weight = new int[this.docIDCount];
        this.start = new long[this.docIDCount];
        this.end = new long[this.docIDCount];
        int i = 0;
        while (i < this.docIDCount) {
            DocumentRanking doc = documentRankings[i];
            this.docIDs[i] = doc.getDocID().toCharArray();
            this.type[i] = doc.getType();
            this.weight[i] = doc.getRank();
            this.start[i] = doc.getStart();
            this.end[i] = doc.getEnd();
            ++i;
        }
    }

    public DocumentRankingElement(char[] keyword, char[][] docIDs, byte[] type, int[] weight, long[] start, long[] end) {
        this.keyword = keyword;
        if (!$assertionsDisabled && docIDs.length != type.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != weight.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != start.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != end.length) {
            throw new AssertionError();
        }
        this.docIDCount = docIDs.length;
        this.docIDs = docIDs;
        this.type = type;
        this.weight = weight;
        this.start = start;
        this.end = end;
    }

    public DocumentRankingElement(String keyword, String[] docIDs, byte[] type, int[] weight, long[] start, long[] end) {
        this.keyword = keyword.toCharArray();
        if (!$assertionsDisabled && docIDs.length != type.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != weight.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != start.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != end.length) {
            throw new AssertionError();
        }
        this.docIDCount = docIDs.length;
        this.docIDs = new char[docIDs.length][];
        int i = 0;
        while (i < docIDs.length) {
            this.docIDs[i] = docIDs[i].toCharArray();
            ++i;
        }
        this.type = type;
        this.weight = weight;
        this.start = start;
        this.end = end;
    }

    public DocumentRankingElement(char[] keyword, byte[] values) throws IOException {
        this.keyword = keyword;
        this.deserializeValues(values);
    }

    public DocumentRankingElement(char[] keyword, int offset, int length, byte[] values) throws IOException {
        this.keyword = new char[length];
        System.arraycopy(keyword, offset, this.keyword, 0, length);
        this.deserializeValues(values);
    }

    public static byte[] createBytes(char[][] docIDs, byte[] type, int[] weight, long[] start, long[] end) throws IOException {
        if (!$assertionsDisabled && docIDs.length != type.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != weight.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != start.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && docIDs.length != end.length) {
            throw new AssertionError();
        }
        int docIDCount = docIDs.length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteUtil.writeVbInt((int)docIDCount));
        int i = 0;
        while (i < docIDCount) {
            baos.write(ByteUtil.writeChars((char[])docIDs[i]));
            baos.write(ByteUtil.writeByte((byte)type[i]));
            baos.write(ByteUtil.writeInt((int)weight[i]));
            baos.write(ByteUtil.writeVbLong((long)start[i]));
            baos.write(ByteUtil.writeVbLong((long)end[i]));
            ++i;
        }
        return baos.toByteArray();
    }

    public byte[] serializeValues() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteUtil.writeVbInt((int)this.docIDCount));
        int i = 0;
        while (i < this.docIDCount) {
            baos.write(ByteUtil.writeChars((char[])this.docIDs[i]));
            baos.write(ByteUtil.writeByte((byte)this.type[i]));
            baos.write(ByteUtil.writeInt((int)this.weight[i]));
            baos.write(ByteUtil.writeVbLong((long)this.start[i]));
            baos.write(ByteUtil.writeVbLong((long)this.end[i]));
            ++i;
        }
        return baos.toByteArray();
    }

    private void deserializeValues(byte[] values) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(values);
        this.docIDCount = ByteUtil.readVbInt((InputStream)bais);
        this.docIDs = new char[this.docIDCount][];
        this.type = new byte[this.docIDCount];
        this.weight = new int[this.docIDCount];
        this.start = new long[this.docIDCount];
        this.end = new long[this.docIDCount];
        int i = 0;
        while (i < this.docIDCount) {
            this.docIDs[i] = ByteUtil.readChars((InputStream)bais);
            this.type[i] = ByteUtil.readByte((InputStream)bais);
            this.weight[i] = ByteUtil.readInt((InputStream)bais);
            this.start[i] = ByteUtil.readVbLong((InputStream)bais);
            this.end[i] = ByteUtil.readVbLong((InputStream)bais);
            ++i;
        }
    }

    public char[] getKeyword() {
        return this.keyword;
    }

    public char[][] getDocIDs() {
        return this.docIDs;
    }

    public char[] getDocID(int index) {
        return this.docIDs[index];
    }

    public byte[] getType() {
        return this.type;
    }

    public byte getType(int index) {
        return this.type[index];
    }

    public int[] getWeight() {
        return this.weight;
    }

    public int getWeight(int index) {
        return this.weight[index];
    }

    public long[] getStart() {
        return this.start;
    }

    public long getStart(int index) {
        return this.start[index];
    }

    public long[] getEnd() {
        return this.end;
    }

    public long getEnd(int index) {
        return this.end[index];
    }

    public int getDocIDSize() {
        return this.docIDCount;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Keyword : ").append(this.keyword).append("]\n");
        buf.append("[DocIDs : ").append(this.docIDCount).append("]\n");
        int i = 0;
        while (i < this.docIDCount) {
            buf.append("[" + i + "]");
            buf.append("[docID : ").append(this.docIDs[i]).append(']');
            buf.append("[Type : ").append(this.type[i]).append(']');
            buf.append("[Weight : ").append(this.weight[i]).append(']');
            buf.append("[Start : ").append(this.start[i]).append(']');
            buf.append("[End : ").append(this.end[i]).append(']');
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public DocumentRankingElement removeExpiredElement() {
        long currentTime = System.currentTimeMillis();
        boolean[] expired = new boolean[this.docIDCount];
        Arrays.fill(expired, false);
        int remainSize = 0;
        int i = 0;
        while (i < this.docIDCount) {
            if (this.start[i] <= currentTime && (this.end[i] == 0L || currentTime <= this.end[i])) {
                ++remainSize;
            } else {
                expired[i] = true;
            }
            ++i;
        }
        if (remainSize == this.docIDCount) {
            return this;
        }
        char[][] ndocs = new char[remainSize][];
        byte[] ntype = new byte[remainSize];
        int[] nweight = new int[remainSize];
        long[] nstart = new long[remainSize];
        long[] nend = new long[remainSize];
        int currentIndex = 0;
        int i2 = 0;
        while (i2 < this.docIDCount) {
            if (!expired[i2]) {
                ndocs[currentIndex] = this.docIDs[i2];
                ntype[currentIndex] = this.type[i2];
                nweight[currentIndex] = this.weight[i2];
                nstart[currentIndex] = this.start[i2];
                nend[currentIndex] = this.end[i2];
                ++currentIndex;
            }
            ++i2;
        }
        DocumentRankingElement newElement = new DocumentRankingElement(this.keyword, ndocs, ntype, nweight, nstart, nend);
        return newElement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocumentRankingElement) {
            DocumentRankingElement o = (DocumentRankingElement)((Object)obj);
            if (!Arrays.equals(this.keyword, o.keyword)) {
                return false;
            }
            if (this.docIDs.length != o.docIDs.length) {
                return false;
            }
            int i = 0;
            while (i < this.docIDs.length) {
                if (!Arrays.equals(this.docIDs[i], o.docIDs[i])) {
                    return false;
                }
                ++i;
            }
            if (!Arrays.equals(this.type, o.type)) {
                return false;
            }
            if (!Arrays.equals(this.weight, o.weight)) {
                return false;
            }
            if (!Arrays.equals(this.start, o.start)) {
                return false;
            }
            if (!Arrays.equals(this.end, o.end)) {
                return false;
            }
            return this.docIDCount == o.docIDCount;
        }
        return false;
    }
}

