/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.dictionary;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.util.common.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;

public class RedirectElement {
    private static final float RESIZE_FACTOR = 1.5f;
    private int urlCount;
    private long[] start;
    private long[] end;
    private char[][] url;

    public boolean equals(Object obj) {
        if (obj instanceof RedirectElement) {
            RedirectElement o = (RedirectElement)obj;
            if (!Arrays.equals((Object[])this.url, (Object[])o.url)) {
                return false;
            }
            if (this.start != o.start) {
                return false;
            }
            return this.end == o.end;
        }
        return false;
    }

    public boolean available(int index) {
        long currentTime = System.currentTimeMillis();
        return this.start[index] <= currentTime && (this.end[index] == 0L || currentTime <= this.end[index]);
    }

    public RedirectElement(long[] start, long[] end, String url) {
        this(start, end, StringUtil.convert((String[])new String[]{url}));
    }

    public RedirectElement(long[] start, long[] end, char[][] url) {
        this.urlCount = url.length;
        this.start = start;
        this.end = end;
        this.url = url;
    }

    public RedirectElement(byte[] values) throws IOException {
        this.deserializeValues(values);
    }

    public static byte[] createBytes(long[] start, long[] end, char[][] url) throws IOException {
        if (start.length != end.length || start.length != url.length) {
            return null;
        }
        if (start.length < 1) {
            return null;
        }
        int urlCount = 0;
        int i = 0;
        while (i < url.length) {
            if (url[i] == null) break;
            ++urlCount;
            ++i;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ByteUtil.writeInt((int)urlCount));
        int i2 = 0;
        while (i2 < urlCount) {
            baos.write(ByteUtil.writeVbLong((long)start[i2]));
            baos.write(ByteUtil.writeVbLong((long)end[i2]));
            baos.write(ByteUtil.writeChars((char[])url[i2]));
            ++i2;
        }
        return baos.toByteArray();
    }

    public byte[] serializeValues() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteUtil.writeInt((int)this.urlCount);
        int i = 0;
        while (i < this.urlCount) {
            baos.write(ByteUtil.writeVbLong((long)this.start[i]));
            baos.write(ByteUtil.writeVbLong((long)this.end[i]));
            baos.write(ByteUtil.writeChars((char[])this.url[i]));
            ++i;
        }
        return baos.toByteArray();
    }

    private void deserializeValues(byte[] values) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(values);
        this.urlCount = ByteUtil.readInt((InputStream)bais);
        this.start = new long[this.urlCount];
        this.end = new long[this.urlCount];
        this.url = new char[this.urlCount][];
        int i = 0;
        while (i < this.urlCount) {
            this.start[i] = ByteUtil.readVbLong((InputStream)bais);
            this.end[i] = ByteUtil.readVbLong((InputStream)bais);
            this.url[i] = ByteUtil.readChars((InputStream)bais);
            ++i;
        }
        bais.close();
    }

    public int getUrlCount() {
        return this.urlCount;
    }

    public long[] getStart() {
        return this.start;
    }

    public long getStart(int index) {
        return this.start[index];
    }

    public long[] getEnd() {
        return this.end;
    }

    public long getEnd(int index) {
        return this.end[index];
    }

    public char[][] getUrl() {
        return this.url;
    }

    public char[] getUrl(int index) {
        return this.url[index];
    }

    public void add(long start, long end, char[] url) {
        this.ensureCapacity();
        this.start[this.urlCount] = start;
        this.end[this.urlCount] = end;
        this.url[this.urlCount] = url;
        ++this.urlCount;
    }

    private void ensureCapacity() {
        if (this.urlCount >= this.url.length) {
            int newSize = this.urlCount > 1 ? (int)((float)this.urlCount * 1.5f) : this.urlCount * 2;
            long[] newStart = new long[newSize];
            long[] newEnd = new long[newSize];
            char[][] newUrl = new char[newSize][];
            System.arraycopy(this.start, 0, newStart, 0, this.urlCount);
            System.arraycopy(this.end, 0, newEnd, 0, this.urlCount);
            System.arraycopy(this.url, 0, newUrl, 0, this.url.length);
            this.start = newStart;
            this.end = newEnd;
            this.url = newUrl;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.urlCount) {
            buf.append("[Url: ").append(this.url[i]).append(']');
            buf.append("[Start : ").append(new Date(this.start[i])).append(']');
            buf.append("[End : ").append(new Date(this.end[i])).append(']');
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }
}

