/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.ext.body.common;

import com.diquest.ir.util.common.TraverseException;
import com.diquest.ir.util.msg.Message;
import com.diquest.ir.util.msg.Transmitable;

public class ErrorMessage
extends Message {
    public static final int INTERNAL_SERVER_ERROR = -100;
    public static final int EXTERNAL_SERVER_ERROR = -200;
    public static final int WAS_ERROR = -300;
    public static final int CONTEXT_DB_ERROR = -400;
    public static final int CONTEXT_XML_PARSE_ERROR = -500;

    public ErrorMessage(String errorMessage, Exception e) {
        super(2);
        this.setString(0, errorMessage);
        TraverseException te = new TraverseException((Throwable)e);
        this.setString(1, te.chain());
    }

    public ErrorMessage(Exception e) {
        super(2);
        TraverseException te = new TraverseException((Throwable)e);
        this.setString(0, te.chainMessage());
        StackTraceElement[] stackTrace = e.getStackTrace();
        StringBuffer buf = new StringBuffer();
        buf.append("Exception Stack Trace : ").append(String.valueOf(e)).append("\n");
        int i = 0;
        while (i < stackTrace.length) {
            buf.append("\tat ").append(stackTrace[i].toString()).append('\n');
            ++i;
        }
        this.setString(1, buf.toString());
    }

    public ErrorMessage(String errorMessage) {
        super(2);
        this.setString(0, errorMessage);
        this.setString(1, "");
    }

    public ErrorMessage() {
    }

    public String getErrorMessage() {
        return this.getString(0);
    }

    public String printStackTrace() {
        return this.getString(1);
    }

    public String getStackTrace() {
        return this.getString(1);
    }

    public Transmitable getInstance() {
        return new ErrorMessage();
    }
}

