/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.ext.body.setting;

import com.diquest.ir.common.msg.ext.body.setting.ExportFile;
import com.diquest.ir.common.msg.ext.body.setting.ExportSummary;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class ExportCollectionSettingFiles
extends Transmitable {
    private int totalFiles;
    private int capacity;
    private ExportSummary summary;
    private ExportFile[] files;

    public ExportCollectionSettingFiles() {
    }

    public ExportCollectionSettingFiles(int capacity) {
        this.init(capacity);
    }

    private void init(int size) {
        this.capacity = size < 5 ? 5 : size;
        this.totalFiles = 0;
        this.summary = new ExportSummary();
        this.files = new ExportFile[this.capacity];
    }

    private void checkCapacity() {
        if (this.totalFiles >= this.capacity) {
            this.capacity = (int)((double)this.capacity * 1.4);
            ExportFile[] newFiles = new ExportFile[this.capacity];
            System.arraycopy(this.files, 0, newFiles, 0, this.totalFiles);
            this.files = newFiles;
        }
    }

    public Iterator iterator() {
        return new ExportFileIterator();
    }

    public void addFile(String dir, String filename, long size, byte[] content) {
        this.checkCapacity();
        this.files[this.totalFiles] = new ExportFile(dir, filename, size, content);
        ++this.totalFiles;
    }

    public ExportSummary getSummary() {
        return this.summary;
    }

    public void setSummary(ExportSummary summary) {
        this.summary = summary;
    }

    public int getTotalSize() {
        return this.totalFiles;
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        this.summary.serialize(out);
        ByteUtil.writeInt((OutputStream)out, (int)this.totalFiles);
        int i = 0;
        while (i < this.totalFiles) {
            this.files[i].serialize(out);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.summary = new ExportSummary();
        this.summary.deserialize(in);
        this.totalFiles = ByteUtil.readInt((InputStream)in);
        this.files = new ExportFile[this.totalFiles];
        int i = 0;
        while (i < this.totalFiles) {
            this.files[i] = new ExportFile();
            this.files[i].deserialize(in);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new ExportCollectionSettingFiles();
    }

    class ExportFileIterator
    implements Iterator {
        private int index = 0;

        public boolean hasNext() {
            return this.index < ExportCollectionSettingFiles.this.totalFiles;
        }

        public Object next() {
            return ExportCollectionSettingFiles.this.files[this.index++];
        }

        public void remove() {
        }
    }
}

