/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.feedback;

import com.diquest.ir.common.msg.feedback.ChurnRateFeedbackInfo;
import com.diquest.ir.common.msg.feedback.Feedback;
import com.diquest.ir.common.msg.feedback.SequenceFeedbackInfo;
import com.diquest.ir.common.msg.feedback.impl.UsabilityFeedback;
import java.util.ArrayList;
import java.util.Iterator;

public class FeedbackSendingChecker {
    private String prefix;
    private String dqpre;
    private String[] sequences;
    private String[] functions;
    private String[] curs;
    private SequenceFeedbackInfo sequenceInfo;
    private ChurnRateFeedbackInfo churnInfo;
    private String[] collnames;
    private String[] profilenames;
    private static final String ID_DELIMITER = "_";

    public FeedbackSendingChecker(String prefix, String functionID, String dqseq, String dqpre, String dqcur, SequenceFeedbackInfo sequenceInfo, ChurnRateFeedbackInfo churnInfo) {
        this.prefix = prefix;
        this.dqpre = dqpre;
        this.functions = functionID.split("[\\s]+");
        this.sequences = dqseq.split("[\\s]+");
        this.curs = dqcur.split("[\\s]+");
        this.sequenceInfo = sequenceInfo;
        this.churnInfo = churnInfo;
    }

    public void splitFunctionID(Feedback[] feedbacks, boolean isFound, String[] collections, String[] profiles) {
        int i = 0;
        while (i < this.functions.length) {
            feedbacks[i] = new UsabilityFeedback(this.functions[i]);
            if (this.functions[i].startsWith(this.prefix) && this.functions[i].indexOf(ID_DELIMITER) != -1) {
                this.splitSingleFunctionID(feedbacks[i], collections, profiles, i);
            } else if (this.functions[i].equalsIgnoreCase("churnrate") && !isFound) {
                this.functions[i] = this.churnInfo.getChurnRateID();
                this.splitSingleFunctionID(feedbacks[i], this.collnames, this.profilenames, i);
            }
            ++i;
        }
    }

    private void splitSingleFunctionID(Feedback feedback, String[] collections, String[] profiles, int i) {
        String[] f = this.functions[i].split(ID_DELIMITER);
        feedback.setMethodName(f[0]);
        if (f.length > 1) {
            feedback.setCollectionID(this.findSplitID(f[1], collections));
        }
        if (f.length > 2) {
            feedback.setProfileID(this.findSplitID(f[2], profiles));
        }
    }

    private String findSplitID(String idxStr, String[] info) {
        try {
            int index = Integer.parseInt(idxStr);
            if (info != null && index <= info.length) {
                return info[index];
            }
        }
        catch (NumberFormatException e) {
            return "";
        }
        return "";
    }

    public Feedback[] makeSendingID(String[] collnames, String[] profilenames) {
        boolean isFound = false;
        this.makeFunctionIDs();
        isFound = this.isChurn();
        this.collnames = collnames;
        this.profilenames = profilenames;
        Feedback[] feedbacks = new UsabilityFeedback[this.functions.length];
        this.splitFunctionID(feedbacks, isFound, collnames, profilenames);
        return this.decideSendingFunction(feedbacks);
    }

    private void makeFunctionIDs() {
        boolean isFound = false;
        ArrayList<Integer> foundIdxList = new ArrayList<Integer>();
        ArrayList<Integer> postList = new ArrayList<Integer>();
        String[] sequenceIDs = this.sequenceInfo.getSequenceIDs();
        String[] sequencePre = this.sequenceInfo.getSequencePre();
        String[] sequencePost = this.sequenceInfo.getSequencePost();
        int i = 0;
        int end = this.functions.length;
        while (i < end) {
            int postStart = 0;
            int postEnd = sequencePost.length;
            while (postStart < postEnd) {
                if (sequencePost[postStart].equals(this.functions[i])) {
                    postList.add(new Integer(postStart));
                }
                ++postStart;
            }
            Iterator it = postList.iterator();
            while (it.hasNext()) {
                Integer preIdx = (Integer)it.next();
                if (!this.dqpre.equals(sequencePre[preIdx])) continue;
                isFound = true;
                foundIdxList.add(preIdx);
            }
            postList.clear();
            ++i;
        }
        if (isFound) {
            String[] tmpArr = new String[this.functions.length + foundIdxList.size()];
            System.arraycopy(this.functions, 0, tmpArr, 0, this.functions.length);
            int i2 = 0;
            while (i2 < foundIdxList.size()) {
                Integer idx = (Integer)foundIdxList.get(i2);
                tmpArr[this.functions.length + i2] = sequenceIDs[idx];
                ++i2;
            }
            this.functions = tmpArr;
        }
    }

    private boolean isChurn() {
        boolean isFound = false;
        boolean isContinue = true;
        String[] churnActiveIDs = this.churnInfo.getChurnActiveIDs();
        String[] churnInactiveIDs = this.churnInfo.getChurnInactiveIDs();
        int i = 0;
        int end = this.functions.length;
        while (i < end) {
            if (this.functions[i].equalsIgnoreCase("churnrate")) {
                int startChurn = 0;
                int endChurn = churnInactiveIDs.length;
                while (startChurn < endChurn) {
                    int cIdx = 0;
                    int cEnd = this.curs.length;
                    while (cIdx < cEnd) {
                        if (churnInactiveIDs[startChurn].equals(this.curs[cIdx])) {
                            isContinue = false;
                            isFound = true;
                            break;
                        }
                        ++cIdx;
                    }
                    if (!isContinue) break;
                    ++startChurn;
                }
                if (isContinue) {
                    int startSeq = 0;
                    int endSeq = this.sequences.length;
                    while (startSeq < endSeq) {
                        int startChurn2 = 0;
                        int endChurn2 = churnActiveIDs.length;
                        while (startChurn2 < endChurn2) {
                            if (churnActiveIDs[startChurn2].equals(this.sequences[startSeq])) {
                                isFound = true;
                                break;
                            }
                            ++startChurn2;
                        }
                        if (isFound) break;
                        ++startSeq;
                    }
                    if (isFound) break;
                }
            }
            ++i;
        }
        return isFound;
    }

    private Feedback[] decideSendingFunction(Feedback[] feedbacks) {
        Feedback[] sendFeedback = new UsabilityFeedback[feedbacks.length];
        int i = 0;
        int end = feedbacks.length;
        while (i < end) {
            String fid = null;
            if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "1")) {
                fid = "F01";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "2")) {
                fid = "F02";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "3")) {
                fid = "F03";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "4")) {
                fid = "F04";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "5")) {
                fid = "F05";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "6")) {
                fid = "F06";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "7")) {
                fid = "F07";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "8")) {
                fid = "F08";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "9")) {
                fid = "F09";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "10")) {
                fid = "F10";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "11")) {
                fid = "F11";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "12")) {
                fid = "F12";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "13")) {
                fid = "F13";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "14")) {
                fid = "F14";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "15")) {
                fid = "F15";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "16")) {
                fid = "F16";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "17")) {
                fid = "F17";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "18")) {
                fid = "F18";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "19")) {
                fid = "F19";
            } else if (feedbacks[i].getMethodName().equals(String.valueOf(this.prefix) + "20")) {
                fid = "F20";
            }
            sendFeedback[i] = new UsabilityFeedback(fid);
            sendFeedback[i].setCollectionID(feedbacks[i].getCollectionID());
            sendFeedback[i].setProfileID(feedbacks[i].getProfileID());
            ++i;
        }
        return sendFeedback;
    }
}

