/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.type.DataT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StringKeyValueSet
implements Measurable {
    private static final int DEFAULT_CAPACITY = 8;
    private char[][] key;
    private char[][] value;
    private int length;
    private int position;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.protocol.StringKeyValueSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StringKeyValueSet() {
        this(8);
    }

    public StringKeyValueSet(int capacity) {
        if (!$assertionsDisabled && capacity <= 0) {
            throw new AssertionError(capacity);
        }
        this.length = 0;
        this.position = 0;
        this.key = new char[capacity][];
        this.value = new char[capacity][];
    }

    private void ensureCapacity() {
        if (this.length >= this.key.length) {
            char[][] newKey = new char[this.length * 2][];
            System.arraycopy(this.key, 0, newKey, 0, this.length);
            this.key = newKey;
            char[][] newValue = new char[this.length * 2][];
            System.arraycopy(this.value, 0, newValue, 0, this.length);
            this.value = newValue;
        }
    }

    public void put(String key, String value) {
        this.put(key.toCharArray(), value.toCharArray());
    }

    public void put(char[] k, char[] v) {
        int i = 0;
        while (i < this.length) {
            if (this.compareChars(this.key[i], k)) {
                this.value[i] = v;
                return;
            }
            ++i;
        }
        this.ensureCapacity();
        this.key[this.length] = k;
        this.value[this.length] = v;
        ++this.length;
    }

    public String get(String k) {
        if (this.position > this.length) {
            this.position = 0;
        }
        int i = 0;
        while (i < this.length) {
            if (this.compareCharAndString(this.key[this.position], k)) {
                if (this.value == null || this.value.length == 0) {
                    return null;
                }
                String v = new String(this.value[this.position]);
                this.position = (this.position + 1) % this.length;
                return v;
            }
            this.position = (this.position + 1) % this.length;
            ++i;
        }
        return null;
    }

    public String[] getKeys() {
        if (this.position > this.length) {
            this.position = 0;
        }
        String[] keys = new String[this.length];
        int i = 0;
        while (i < this.length) {
            keys[i] = String.valueOf(this.key[this.position]);
            this.position = (this.position + 1) % this.length;
            ++i;
        }
        return keys;
    }

    private boolean compareCharAndString(char[] ch, String str) {
        if (ch == null || str == null) {
            return false;
        }
        if (ch.length != str.length()) {
            return false;
        }
        int i = 0;
        while (i < ch.length) {
            if (ch[i] != str.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareChars(char[] first, char[] second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            if (first[i] != second[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeVbInt((OutputStream)out, (int)this.length);
        int i = 0;
        while (i < this.length) {
            ByteUtil.writeChars((OutputStream)out, (char[])this.key[i]);
            ByteUtil.writeChars((OutputStream)out, (char[])this.value[i]);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        int inSize = ByteUtil.readVbInt((InputStream)in);
        int i = 0;
        while (i < inSize) {
            char[] key = ByteUtil.readChars((InputStream)in);
            char[] value = ByteUtil.readChars((InputStream)in);
            this.put(key, value);
            ++i;
        }
        this.length = inSize;
    }

    public Transmitable getInstance() {
        return new DataT();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[StringKeyValueSet length[" + this.length + "]: ");
        int i = 0;
        while (i < this.length) {
            if (this.key[i] != null) {
                buffer.append("(" + i + "th key: " + new String(this.key[i]));
                buffer.append(" value: " + new String(this.value[i]) + "), ");
            }
            ++i;
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public int hashCode() {
        return this.value == null ? 0 : 1575 + this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        StringKeyValueSet castedObj = (StringKeyValueSet)o;
        if (this.length != castedObj.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (!this.compareChars(this.key[i], castedObj.key[i])) {
                return false;
            }
            if (!this.compareChars(this.value[i], castedObj.value[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int size() {
        int size = 0;
        int i = 0;
        while (i < this.length) {
            size += SizeUtil.sizeOf((char[])this.key[i]);
            size += SizeUtil.sizeOf((char[])this.value[i]);
            ++i;
        }
        return size += this.key.length * 4 + 84;
    }
}

