/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.broker;

import com.diquest.ir.common.setting.broker.Collection;
import com.diquest.ir.common.setting.broker.impl.CollectionImpl;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;

public class BrokerInfo
extends Transmitable {
    private String id;
    private Collection[] clist;
    private boolean brokerQueryModifier;
    private boolean brokerResultModifier;

    public BrokerInfo(String id, Collection[] clist) {
        this(id, clist, true, true);
    }

    public BrokerInfo(String id, Collection[] clist, boolean brokerQueryModifier, boolean brokerResultModifier) {
        this.id = id;
        this.clist = clist;
        this.brokerQueryModifier = brokerQueryModifier;
        this.brokerResultModifier = brokerResultModifier;
    }

    public BrokerInfo() {
    }

    public Collection[] getClist() {
        return this.clist;
    }

    public String getId() {
        return this.id;
    }

    public boolean isBrokerQueryModifier() {
        return this.brokerQueryModifier;
    }

    public boolean isBrokerResultModifier() {
        return this.brokerResultModifier;
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.id);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.brokerQueryModifier);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.brokerResultModifier);
        ByteUtil.writeInt((OutputStream)out, (int)this.clist.length);
        int i = 0;
        while (i < this.clist.length) {
            ByteUtil.writeString((OutputStream)out, (String)this.clist[i].getCollectionId());
            ByteUtil.writeString((OutputStream)out, (String)this.clist[i].getIp());
            ByteUtil.writeInt((OutputStream)out, (int)this.clist[i].getPort());
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.id = ByteUtil.readString((InputStream)in);
        this.brokerQueryModifier = ByteUtil.readBoolean((InputStream)in);
        this.brokerResultModifier = ByteUtil.readBoolean((InputStream)in);
        int size = ByteUtil.readInt((InputStream)in);
        this.clist = new Collection[size];
        int i = 0;
        while (i < size) {
            String cid = ByteUtil.readString((InputStream)in);
            String ip = ByteUtil.readString((InputStream)in);
            int port = ByteUtil.readInt((InputStream)in);
            CollectionImpl c = new CollectionImpl();
            c.setCollectionId(cid);
            c.setIp(ip);
            c.setPort(port);
            this.clist[i] = c;
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof BrokerInfo)) {
            return false;
        }
        BrokerInfo cast = (BrokerInfo)((Object)o);
        if (!this.id.equals(cast.id)) {
            return false;
        }
        if (this.clist.length != cast.clist.length) {
            return false;
        }
        if (this.brokerQueryModifier != cast.brokerQueryModifier) {
            return false;
        }
        if (this.brokerResultModifier != cast.brokerResultModifier) {
            return false;
        }
        int length = this.clist.length;
        Collection[] tempSource = new Collection[length];
        Collection[] tempDest = new Collection[length];
        System.arraycopy(this.clist, 0, tempSource, 0, length);
        System.arraycopy(cast.clist, 0, tempDest, 0, length);
        Comparator collectionComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Collection c1 = (Collection)o1;
                Collection c2 = (Collection)o2;
                int diff = c1.getCollectionId().compareTo(c2.getCollectionId());
                if (diff == 0) {
                    diff = c1.getIp().compareTo(c2.getIp());
                }
                if (diff == 0) {
                    diff = c1.getPort() - c2.getPort();
                }
                return diff;
            }
        };
        Arrays.sort(tempSource, collectionComparator);
        Arrays.sort(tempDest, collectionComparator);
        int i = 0;
        while (i < length) {
            int diff = collectionComparator.compare(tempSource[i], tempDest[i]);
            if (diff != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.id.hashCode() & Integer.MAX_VALUE;
    }

    public Transmitable getInstance() {
        return new BrokerInfo();
    }
}

