/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.broker;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.CharBuffer;
import com.diquest.ir.util.common.CharUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BrokerPagingInfo
extends Transmitable {
    private static int ENCSTART = 22;
    private static int ENCSC = 65;
    private int ENCEC = 90;
    private static int ENCSL = 97;
    private static int ENCEL = 122;
    private static String NEGATIVE = "@";
    private String[] ips;
    private int start;
    private int end;
    private int[] ports;
    private int[] startNums;
    private int[] endNums;
    private boolean previous = false;

    public BrokerPagingInfo(int start, int end, String[] ips, int[] ports, int[] startNums, int[] endNums) {
        this.start = start;
        this.end = end;
        this.ips = ips;
        this.ports = ports;
        this.startNums = startNums;
        this.endNums = endNums;
        int i = 0;
        while (i < ips.length) {
            if (ips[i].equalsIgnoreCase("localhost")) {
                ips[i] = "127.0.0.1";
            }
            ++i;
        }
    }

    public BrokerPagingInfo() {
    }

    public void mergeActualInfo(boolean first, int[] starts, int[] ends) {
        if (first) {
            return;
        }
        int i = 0;
        while (i < this.ips.length) {
            if (this.startNums[i] < 0) {
                this.startNums[i] = ends[i];
            }
            if (this.endNums[i] < 0) {
                this.endNums[i] = ends[i];
            }
            ++i;
        }
    }

    public void setPrevious() {
        this.previous = true;
    }

    public int getStartNum(String ip, int port) {
        int i = 0;
        while (i < this.ips.length) {
            if (ip.equals(this.ips[i]) && port == this.ports[i]) {
                return this.startNums[i];
            }
            ++i;
        }
        return -1;
    }

    public int getEndNum(String ip, int port) {
        int i = 0;
        while (i < this.ips.length) {
            if (ip.equals(this.ips[i]) && port == this.ports[i]) {
                return this.endNums[i];
            }
            ++i;
        }
        return -1;
    }

    public int[] getEndNums() {
        return this.endNums;
    }

    public int[] getStartNums() {
        return this.startNums;
    }

    public String[] getServers() {
        return this.ips;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public boolean isPrevious() {
        return this.previous;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[start =" + this.start + " end = " + this.end + "]\n");
        int i = 0;
        while (i < this.ips.length) {
            buf.append("[IP : " + this.ips[i] + "\tPORT : " + this.ports[i] + "\tstartNum : " + this.startNums[i] + "\tendNum : " + this.endNums[i] + "]").append('\n');
            ++i;
        }
        return buf.toString();
    }

    public String convertString() {
        char[] newChars = this.convert();
        return new String(newChars);
    }

    public char[] convert() {
        CharBuffer buf = new CharBuffer();
        buf.append(this.start).append('|');
        buf.append(this.end).append('|');
        buf.append(this.ips.length).append('|');
        int i = 0;
        while (i < this.ips.length) {
            buf.append(this.ips[i].replace('.', '|')).append('|');
            buf.append(this.ports[i]).append('|');
            if (this.startNums[i] >= 0) {
                buf.append(this.startNums[i]).append('|');
            } else {
                buf.append('@').append('|');
            }
            if (this.endNums[i] >= 0) {
                buf.append(this.endNums[i]).append('|');
            } else {
                buf.append('@').append('|');
            }
            ++i;
        }
        char[] chars = buf.toCharArray();
        chars = CharUtil.toLowerCase((char[])chars);
        char[] newChars = new char[chars.length];
        int i2 = 0;
        while (i2 < chars.length) {
            newChars[i2] = chars[i2] == '@' ? 48 : (chars[i2] != '|' ? (char)((chars[i2] + ENCSTART + i2) % 26 + ENCSC) : (char)((this.ENCEC + i2) % 26 + ENCSL));
            ++i2;
        }
        return newChars;
    }

    public static BrokerPagingInfo getObject(char[] src) throws IOException {
        char[] nsrcc = new char[src.length];
        int i = 0;
        while (i < src.length) {
            if (src[i] == '0') {
                nsrcc[i] = 64;
            } else if (ENCSL <= src[i] && src[i] <= ENCEL) {
                nsrcc[i] = 124;
            } else {
                int n = src[i] - ENCSC - ENCSTART - i;
                while (n < 48) {
                    n += 26;
                }
                nsrcc[i] = (char)n;
            }
            ++i;
        }
        if (nsrcc == null || nsrcc.length == 0) {
            return null;
        }
        int beginPos = 0;
        int endPos = 0;
        endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
        int start = Integer.parseInt(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos));
        beginPos = endPos + 1;
        endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
        int end = Integer.parseInt(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos));
        beginPos = endPos + 1;
        endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
        int size = Integer.parseInt(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos));
        beginPos = endPos + 1;
        String[] ips = new String[size];
        int[] ports = new int[size];
        int[] startNums = new int[size];
        int[] endNums = new int[size];
        int i2 = 0;
        while (i2 < size) {
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            StringBuffer ipBuf = new StringBuffer();
            ipBuf.append(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos)).append('.');
            beginPos = endPos + 1;
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            ipBuf.append(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos)).append('.');
            beginPos = endPos + 1;
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            ipBuf.append(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos)).append('.');
            beginPos = endPos + 1;
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            ipBuf.append(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos));
            ips[i2] = ipBuf.toString();
            beginPos = endPos + 1;
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            ports[i2] = Integer.parseInt(CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos));
            beginPos = endPos + 1;
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            String ss = CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos);
            startNums[i2] = ss.equalsIgnoreCase(NEGATIVE) ? -1 : Integer.parseInt(ss);
            beginPos = endPos + 1;
            endPos = CharUtil.indexOf((char[])nsrcc, (char)'|', (int)beginPos);
            String ee = CharUtil.substring((char[])nsrcc, (int)beginPos, (int)endPos);
            endNums[i2] = ee.equalsIgnoreCase(NEGATIVE) ? -1 : Integer.parseInt(ee);
            beginPos = endPos + 1;
            ++i2;
        }
        return new BrokerPagingInfo(start, end, ips, ports, startNums, endNums);
    }

    public void serialize(OutputStream out) throws IOException {
        if (this.ips == null) {
            ByteUtil.writeBoolean((boolean)false);
        } else {
            ByteUtil.writeBoolean((boolean)true);
            ByteUtil.writeInt((OutputStream)out, (int)this.ips.length);
            int i = 0;
            while (i < this.ips.length) {
                ByteUtil.writeString((OutputStream)out, (String)this.ips[i]);
                ByteUtil.writeVbInt((OutputStream)out, (int)this.ports[i]);
                ByteUtil.writeVbInt((OutputStream)out, (int)this.startNums[i]);
                ByteUtil.writeVbInt((OutputStream)out, (int)this.endNums[i]);
                ++i;
            }
        }
    }

    public void deserialize(InputStream in) throws IOException {
        boolean isNull = ByteUtil.readBoolean((InputStream)in);
        if (!isNull) {
            int size = ByteUtil.readInt((InputStream)in);
            this.ips = new String[size];
            this.ports = new int[size];
            this.startNums = new int[size];
            this.endNums = new int[size];
            int i = 0;
            while (i < size) {
                this.ips[i] = ByteUtil.readString((InputStream)in);
                this.ports[i] = ByteUtil.readVbInt((InputStream)in);
                this.startNums[i] = ByteUtil.readVbInt((InputStream)in);
                this.endNums[i] = ByteUtil.readVbInt((InputStream)in);
                ++i;
            }
        }
    }

    public Transmitable getInstance() {
        return new BrokerPagingInfo();
    }

    public boolean isNull() {
        return false;
    }

    public static void main(String[] args) throws IOException {
        BrokerPagingInfo info = new BrokerPagingInfo(1, 2, new String[]{"localhost", "211.238.196.40", "211.238.196.41"}, new int[]{5555, 5555, 6666}, new int[]{1, 2, 3}, new int[]{11, 22, 33});
        char[] str = info.convert();
        BrokerPagingInfo newInfo = BrokerPagingInfo.getObject(str);
        String[] servers = newInfo.getServers();
        int[] ports = newInfo.getPorts();
        int[] startNums = newInfo.getStartNums();
        int[] endNums = newInfo.getEndNums();
        int i = 0;
        while (i < servers.length) {
            System.out.println(String.valueOf(servers[i]) + " " + ports[i] + " " + startNums[i] + " " + endNums[i]);
            ++i;
        }
    }
}

