/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.log;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.VectorUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class QueryLogContainer
extends Transmitable {
    private static final int DEFAULT_BUCKET_SIZE = 8192;
    private static final int DEFAULT_ARRAY_LENGTH = 4096;
    private static final int HASH_SEED = 1159241;
    private int queryCount = 0;
    private int bucketSize;
    private byte[][] queryByteMap;
    private int[] arrayPos;
    private long avgQueryTimeSlice = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.protocol.log.QueryLogContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public QueryLogContainer(int bucketSize) {
        this.init(bucketSize);
    }

    public QueryLogContainer() {
        this.init(8192);
    }

    public synchronized QueryLogContainer cloneAndInit() {
        QueryLogContainer newOne = new QueryLogContainer();
        newOne.queryCount = this.queryCount;
        newOne.bucketSize = this.bucketSize;
        newOne.queryByteMap = new byte[this.queryByteMap.length][];
        int i = 0;
        while (i < this.queryByteMap.length) {
            if (this.queryByteMap[i] != null) {
                newOne.queryByteMap[i] = new byte[this.queryByteMap[i].length];
                System.arraycopy(this.queryByteMap[i], 0, newOne.queryByteMap[i], 0, this.queryByteMap[i].length);
            }
            ++i;
        }
        newOne.arrayPos = new int[this.arrayPos.length];
        System.arraycopy(this.arrayPos, 0, newOne.arrayPos, 0, this.arrayPos.length);
        newOne.avgQueryTimeSlice = this.avgQueryTimeSlice;
        this.init();
        return newOne;
    }

    public void init(int bucketSize) {
        this.bucketSize = bucketSize;
        this.queryByteMap = new byte[bucketSize][];
        this.arrayPos = new int[bucketSize];
        this.queryCount = 0;
        this.avgQueryTimeSlice = 0L;
    }

    public void init() {
        this.init(8192);
    }

    public int addTerm(String term, long responseTime) {
        return this.addTerm(term, 1, responseTime);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int addTerm(String term, int count, long responseTime) {
        block4: {
            if (!QueryLogContainer.$assertionsDisabled && responseTime < 0L) {
                throw new AssertionError();
            }
            hashValue = this.hashCode(term);
            offset = 0;
            if (this.queryByteMap[hashValue] != null) ** GOTO lbl15
            this.queryByteMap[hashValue] = new byte[4096];
            break block4;
lbl-1000:
            // 1 sources

            {
                readString = QueryLogContainer.readString(this.queryByteMap[hashValue], offset);
                offset += 4 + readString.length() * 2;
                if (readString.equals(term)) {
                    offset = QueryLogContainer.incInt(this.queryByteMap[hashValue], offset, count);
                    offset = QueryLogContainer.incLong(this.queryByteMap[hashValue], offset, responseTime);
                    return offset;
                }
                offset += 12;
lbl15:
                // 2 sources

                ** while (offset < this.arrayPos[hashValue])
            }
        }
        if ((double)this.arrayPos[hashValue] * 1.2 >= (double)this.queryByteMap[hashValue].length) {
            this.widenArray(hashValue);
        }
        offset = this.arrayPos[hashValue];
        offset = QueryLogContainer.writeString(this.queryByteMap[hashValue], offset, term);
        offset = QueryLogContainer.writeInt(this.queryByteMap[hashValue], offset, count);
        this.arrayPos[hashValue] = offset = QueryLogContainer.writeLong(this.queryByteMap[hashValue], offset, responseTime);
        ++this.queryCount;
        return this.arrayPos[hashValue];
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int getTermCount(String term) {
        hashValue = this.hashCode(term);
        offset = 0;
        if (this.queryByteMap[hashValue] != null) ** GOTO lbl9
        return 0;
lbl-1000:
        // 1 sources

        {
            readString = QueryLogContainer.readString(this.queryByteMap[hashValue], offset);
            if (readString.equals(term)) {
                return QueryLogContainer.readInt(this.queryByteMap[hashValue], offset += 4 + term.length() * 2);
            }
            offset += 16 + readString.length() * 2;
lbl9:
            // 2 sources

            ** while (offset < this.arrayPos[hashValue])
        }
lbl10:
        // 1 sources

        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized long getTermResponseTime(String term) {
        hashValue = this.hashCode(term);
        offset = 0;
        if (this.queryByteMap[hashValue] != null) ** GOTO lbl9
        return 0L;
lbl-1000:
        // 1 sources

        {
            readString = QueryLogContainer.readString(this.queryByteMap[hashValue], offset);
            if (readString.equals(term)) {
                return QueryLogContainer.readLong(this.queryByteMap[hashValue], offset += 8 + term.length() * 2);
            }
            offset += 16 + readString.length() * 2;
lbl9:
            // 2 sources

            ** while (offset < this.arrayPos[hashValue])
        }
lbl10:
        // 1 sources

        return 0L;
    }

    public QueryLogContainerIterator iterator() {
        return new QueryLogContainerIterator(this);
    }

    private synchronized int widenArray(int arrayId) {
        byte[] newArray = new byte[this.queryByteMap[arrayId].length + 4096];
        System.arraycopy(this.queryByteMap[arrayId], 0, newArray, 0, this.queryByteMap[arrayId].length);
        this.queryByteMap[arrayId] = newArray;
        return newArray.length;
    }

    private int hashCode(String term) {
        return Math.abs(term.hashCode()) % this.bucketSize;
    }

    private static final int writeString(byte[] out, int offset, String value) {
        int currentOffset = offset;
        char[] valueArray = value.toCharArray();
        byte[] out2 = VectorUtil.charToByte((char[])value.toCharArray(), (int)0, (int)valueArray.length);
        currentOffset = QueryLogContainer.writeInt(out, currentOffset, out2.length);
        int i = 0;
        while (i < out2.length) {
            out[currentOffset++] = out2[i];
            ++i;
        }
        return currentOffset;
    }

    private static final String readString(byte[] in, int offset) {
        int length = QueryLogContainer.readInt(in, offset);
        char[] buf = VectorUtil.byteToChar((byte[])in, (int)(offset += 4), (int)length);
        return new String(buf);
    }

    private static final int incInt(byte[] out, int offset) {
        return QueryLogContainer.writeInt(out, offset, QueryLogContainer.readInt(out, offset) + 1);
    }

    private static final int incInt(byte[] out, int offset, int size) {
        return QueryLogContainer.writeInt(out, offset, QueryLogContainer.readInt(out, offset) + size);
    }

    private static final int incLong(byte[] out, int offset, long size) {
        return QueryLogContainer.writeLong(out, offset, QueryLogContainer.readLong(out, offset) + size);
    }

    public static final int writeInt(byte[] out, int offset, int value) {
        VectorUtil.writeInt((byte[])out, (int)offset, (int)value);
        return offset + 4;
    }

    public static final int readInt(byte[] in, int offset) {
        return VectorUtil.readInt((byte[])in, (int)offset);
    }

    public static final int writeLong(byte[] out, int offset, long value) {
        VectorUtil.writeLong((byte[])out, (int)offset, (long)value);
        return offset + 8;
    }

    public static final long readLong(byte[] in, int offset) {
        return VectorUtil.readLong((byte[])in, (int)offset);
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeInt((OutputStream)out, (int)this.bucketSize);
        ByteUtil.writeInt((OutputStream)out, (int)this.queryCount);
        ByteUtil.writeLong((OutputStream)out, (long)this.avgQueryTimeSlice);
        int i = 0;
        while (i < this.queryByteMap.length) {
            ByteUtil.writeInt((OutputStream)out, (int)this.arrayPos[i]);
            if (this.arrayPos[i] > 0) {
                out.write(this.queryByteMap[i], 0, this.arrayPos[i]);
            }
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.bucketSize = ByteUtil.readInt((InputStream)in);
        this.queryCount = ByteUtil.readInt((InputStream)in);
        this.avgQueryTimeSlice = ByteUtil.readLong((InputStream)in);
        int i = 0;
        while (i < this.bucketSize) {
            this.arrayPos[i] = ByteUtil.readInt((InputStream)in);
            if (this.arrayPos[i] > 0) {
                this.queryByteMap[i] = new byte[this.calcArraySize(this.arrayPos[i])];
                in.read(this.queryByteMap[i], 0, this.arrayPos[i]);
            }
            ++i;
        }
    }

    public int calcArraySize(int size) {
        return (size / 4096 + 1) * 4096;
    }

    public Transmitable getInstance() {
        return new QueryLogContainer();
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public int totalSize() {
        int size = 0;
        int i = 0;
        while (i < this.arrayPos.length) {
            size += this.arrayPos[i];
            ++i;
        }
        return size;
    }

    public long getAvgQueryTimeSlice() {
        return this.avgQueryTimeSlice;
    }

    public void setAvgQueryTimeSlice(long avgQueryTimeSlice) {
        this.avgQueryTimeSlice = avgQueryTimeSlice;
    }

    public void trimDownQueryTimeSlice() {
        this.avgQueryTimeSlice -= this.avgQueryTimeSlice % 3600000L;
    }

    static /* synthetic */ int access$1(QueryLogContainer queryLogContainer) {
        return queryLogContainer.bucketSize;
    }

    static /* synthetic */ int[] access$2(QueryLogContainer queryLogContainer) {
        return queryLogContainer.arrayPos;
    }

    static /* synthetic */ byte[][] access$3(QueryLogContainer queryLogContainer) {
        return queryLogContainer.queryByteMap;
    }

    static /* synthetic */ String access$4(byte[] byArray, int n) {
        return QueryLogContainer.readString(byArray, n);
    }

    class QueryLogContainerIterator
    implements Iterator {
        QueryLogContainer container;
        int currentCount = 0;
        int currentArray = 0;
        int currentOffset = 0;

        public QueryLogContainerIterator(QueryLogContainer container) {
            this.container = container;
        }

        public boolean hasNext() {
            return this.currentCount < this.container.queryCount;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            if (this.currentArray < QueryLogContainer.access$1(this.container)) ** GOTO lbl5
            return null;
lbl-1000:
            // 1 sources

            {
                ++this.currentArray;
                this.currentOffset = 0;
lbl5:
                // 2 sources

                ** while (this.currentOffset >= QueryLogContainer.access$2((QueryLogContainer)this.container)[this.currentArray])
            }
lbl6:
            // 1 sources

            term = QueryLogContainer.access$4(QueryLogContainer.access$3(this.container)[this.currentArray], this.currentOffset);
            this.currentOffset += 16 + term.length() * 2;
            ++this.currentCount;
            return term;
        }

        public void remove() {
        }
    }
}

