/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class DistanceSet
implements Measurable {
    private char[] field;
    private char[][] coordinates;

    public DistanceSet(char[] field, char[][] coordinates) {
        this.field = field;
        this.coordinates = coordinates;
    }

    public DistanceSet(String field, String[] coordinates) {
        this.field = field.toCharArray();
        this.coordinates = new char[coordinates.length][];
        int i = 0;
        while (i < coordinates.length) {
            this.coordinates[i] = coordinates[i].toCharArray();
            ++i;
        }
    }

    public char[] getField() {
        return this.field;
    }

    public char[][] getCoordinates() {
        return this.coordinates;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DistanceSet [field = ");
        buf.append(this.field);
        buf.append("][coordinates = ");
        int i = 0;
        while (i < this.coordinates.length) {
            buf.append('[');
            buf.append(this.coordinates[i]);
            buf.append(']');
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.field);
        ByteUtil.writeInt((OutputStream)out, (int)this.coordinates.length);
        int k = 0;
        while (k < this.coordinates.length) {
            ByteUtil.writeChars((OutputStream)out, (char[])this.coordinates[k]);
            ++k;
        }
    }

    public static DistanceSet deserialize(InputStream in) throws IOException {
        char[] fields = ByteUtil.readChars((InputStream)in);
        int coordinatesSize = ByteUtil.readInt((InputStream)in);
        char[][] coordinates = new char[coordinatesSize][];
        int k = 0;
        while (k < coordinatesSize) {
            coordinates[k] = ByteUtil.readChars((InputStream)in);
            ++k;
        }
        return new DistanceSet(fields, coordinates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        DistanceSet casted = (DistanceSet)o;
        if (!Arrays.equals(this.field, casted.field)) {
            return false;
        }
        if (this.coordinates.length != casted.coordinates.length) {
            return false;
        }
        int i = 0;
        while (i < this.coordinates.length) {
            if (!Arrays.equals(this.coordinates[i], casted.coordinates[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int size() {
        int size = SizeUtil.sizeOf((char[])this.field) + SizeUtil.OBJECT_OVERHEAD + 4;
        int i = 0;
        while (i < this.coordinates.length) {
            if (this.coordinates[i] != null) {
                size += SizeUtil.sizeOf((char[])this.coordinates[i]);
            }
            ++i;
        }
        return size;
    }
}

