/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class FilterSet
implements Measurable,
Serializable {
    private static final long serialVersionUID = 7311858725700392884L;
    private byte operation;
    private char[] field;
    private char[][] keyword;
    private int weight;

    public FilterSet(byte operation, char[] field, char[][] keyword, int weight) {
        this.operation = operation;
        this.field = field;
        this.keyword = keyword;
        this.weight = weight;
    }

    public FilterSet(byte operation, char[] field, char[][] keyword) {
        this(operation, field, keyword, 0);
    }

    public FilterSet(byte operation, String field, String[] keyword, int weight) {
        this(operation, field.toCharArray(), new char[keyword.length][], weight);
        int i = 0;
        while (i < keyword.length) {
            this.keyword[i] = keyword[i].toCharArray();
            ++i;
        }
    }

    public FilterSet(byte operation, String field, String[] keyword) {
        this(operation, field, keyword, 0);
    }

    public FilterSet(byte operation, char[] field, String keyword, int weight) {
        this(operation, field, new char[1][], weight);
        this.keyword[0] = keyword.toCharArray();
    }

    public FilterSet(byte operation, char[] field, String keyword) {
        this(operation, field, keyword, 0);
    }

    public FilterSet(byte operation, String field, String keyword) {
        this(operation, field.toCharArray(), keyword, 0);
    }

    public FilterSet(byte operation, String field, String keyword, int weight) {
        this(operation, field.toCharArray(), keyword, weight);
    }

    public char[] getField() {
        return this.field;
    }

    public byte getOperation() {
        return this.operation;
    }

    public char[][] getKeyword() {
        return this.keyword;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        FilterSet castedObj = (FilterSet)o;
        if (this.keyword.length != castedObj.keyword.length) {
            return false;
        }
        int i = 0;
        while (i < this.keyword.length) {
            if (!Arrays.equals(this.keyword[i], castedObj.keyword[i])) {
                return false;
            }
            ++i;
        }
        return this.operation == castedObj.operation && this.weight == castedObj.weight && Arrays.equals(this.field, castedObj.field);
    }

    public int size() {
        int size = SizeUtil.sizeOf((char[])this.field) + 9 + SizeUtil.OBJECT_OVERHEAD;
        int i = 0;
        while (i < this.keyword.length) {
            size += SizeUtil.sizeOf((char[])this.keyword[i]);
            ++i;
        }
        return size;
    }

    public String toString() {
        String keywords = "";
        int i = 0;
        while (i < this.keyword.length) {
            keywords = String.valueOf(keywords) + (this.keyword[i] != null ? String.valueOf(new String(this.keyword[i])) + "\n" : "");
            ++i;
        }
        return "[FilterSet [operation = " + this.operation + "][field = " + new String(this.field) + "]\n[keywords = " + keywords + "]\n[weight = " + this.weight + "]";
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeByte((OutputStream)out, (byte)this.operation);
        ByteUtil.writeChars((OutputStream)out, (char[])this.field);
        ByteUtil.writeInt((OutputStream)out, (int)this.keyword.length);
        int k = 0;
        while (k < this.keyword.length) {
            ByteUtil.writeChars((OutputStream)out, (char[])this.keyword[k]);
            ++k;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.weight);
    }

    public static FilterSet deserialize(InputStream in) throws IOException {
        byte operation = ByteUtil.readByte((InputStream)in);
        char[] fields = ByteUtil.readChars((InputStream)in);
        int keywordSize = ByteUtil.readInt((InputStream)in);
        char[][] keyword = new char[keywordSize][];
        int k = 0;
        while (k < keywordSize) {
            keyword[k] = ByteUtil.readChars((InputStream)in);
            ++k;
        }
        int weight = ByteUtil.readInt((InputStream)in);
        return new FilterSet(operation, fields, keyword, weight);
    }
}

