/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class GroupBySet
implements Measurable {
    private char[] field;
    private byte operation;
    private char[] argument;
    private char[][] groupFilter;

    public GroupBySet(char[] field, byte operation, char[] argument, char[] groupFilter) {
        this.field = field;
        this.operation = operation;
        this.argument = argument;
        this.groupFilter = new char[1][];
        this.groupFilter[0] = groupFilter;
    }

    public GroupBySet(String field, byte operation, String argument, String groupFilter) {
        this.field = field.toCharArray();
        this.operation = operation;
        this.argument = argument.toCharArray();
        this.groupFilter = new char[1][];
        this.groupFilter[0] = groupFilter.toCharArray();
    }

    public GroupBySet(String field, byte operation, String argument, String[] groupFilters) {
        this.field = field.toCharArray();
        this.operation = operation;
        this.argument = argument.toCharArray();
        this.groupFilter = new char[groupFilters.length][];
        int i = 0;
        while (i < groupFilters.length) {
            this.groupFilter[i] = groupFilters[i].toCharArray();
            ++i;
        }
    }

    public GroupBySet(char[] field, byte operation, char[] argument, char[][] groupFilters) {
        this.field = field;
        this.operation = operation;
        this.argument = argument;
        this.groupFilter = groupFilters;
    }

    public GroupBySet(String field, byte operation, String argument) {
        this(field.toCharArray(), operation, argument.toCharArray(), new char[0][]);
    }

    public char[] getField() {
        return this.field;
    }

    public byte getOperation() {
        return this.operation;
    }

    public char[] getArgument() {
        return this.argument;
    }

    public char[][] getGroupFilter() {
        return this.groupFilter;
    }

    public void setOperation(byte operation) {
        this.operation = operation;
    }

    public void setArgument(char[] argument) {
        this.argument = argument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        GroupBySet casted = (GroupBySet)o;
        if (this.groupFilter.length != casted.groupFilter.length) {
            return false;
        }
        int i = 0;
        while (i < this.groupFilter.length) {
            if (!Arrays.equals(this.groupFilter[i], casted.groupFilter[i])) {
                return false;
            }
            ++i;
        }
        return Arrays.equals(this.field, casted.field) && this.operation == casted.operation && Arrays.equals(this.argument, casted.argument);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GroupBySet");
        buffer.append(" [field = ");
        buffer.append(this.field);
        buffer.append("] [operation = ");
        buffer.append(this.operation);
        buffer.append("] [argument = ");
        buffer.append(this.argument);
        buffer.append("] [groupFilter = ");
        if (this.groupFilter != null) {
            int i = 0;
            while (i < this.groupFilter.length) {
                buffer.append(this.groupFilter[i]);
                if (i < this.groupFilter.length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public int size() {
        int size = 13 + SizeUtil.OBJECT_OVERHEAD;
        size += SizeUtil.sizeOf((char[])this.field);
        size += SizeUtil.sizeOf((char[])this.argument);
        return size += SizeUtil.sizeOf((char[][])this.groupFilter);
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.field);
        ByteUtil.writeByte((OutputStream)out, (byte)this.operation);
        ByteUtil.writeChars((OutputStream)out, (char[])this.argument);
        if (this.groupFilter != null) {
            ByteUtil.writeInt((OutputStream)out, (int)this.groupFilter.length);
            int i = 0;
            while (i < this.groupFilter.length) {
                ByteUtil.writeChars((OutputStream)out, (char[])this.groupFilter[i]);
                ++i;
            }
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        }
    }

    public static GroupBySet deserialize(InputStream in) throws IOException {
        char[] field = ByteUtil.readChars((InputStream)in);
        byte operation = ByteUtil.readByte((InputStream)in);
        char[] argument = ByteUtil.readChars((InputStream)in);
        int size = ByteUtil.readInt((InputStream)in);
        char[][] groupFilter = new char[size][];
        int i = 0;
        while (i < size) {
            groupFilter[i] = ByteUtil.readChars((InputStream)in);
            ++i;
        }
        GroupBySet groupBySet = new GroupBySet(field, operation, argument, groupFilter);
        return groupBySet;
    }
}

